/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import java.io.IOException;
import js.tinyvm.ClassRecord;
import js.tinyvm.TinyVMException;
import js.tinyvm.TinyVMType;
import js.tinyvm.WritableData;
import js.tinyvm.io.IByteWriter;
import org.apache.bcel.classfile.Field;

public class StaticFieldRecord
implements WritableData {
    ClassRecord iClassRecord;
    Field iField;
    boolean isUsed = false;

    public StaticFieldRecord(Field aEntry, ClassRecord aRec) {
        this.iField = aEntry;
        this.iClassRecord = aRec;
    }

    public String getName() {
        return this.iField.getName();
    }

    public int getLength() {
        return 2;
    }

    public void dump(IByteWriter aOut) throws TinyVMException {
        TinyVMType type = TinyVMType.tinyVMType(this.iField.getType());
        int pOffset = this.iClassRecord.getStaticFieldOffset(this.iField.getName());
        assert (pOffset >= 0 && pOffset <= 4095) : "Check offset in range";
        try {
            aOut.writeU2(type.type() << 12 | pOffset);
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }

    public boolean equals(Object aOther) {
        if (!(aOther instanceof StaticFieldRecord)) {
            return false;
        }
        return ((StaticFieldRecord)aOther).iField.equals(this.iField) && ((StaticFieldRecord)aOther).iClassRecord.equals(this.iClassRecord);
    }

    public int hashCode() {
        return this.iField.hashCode();
    }

    public void markUsed() {
        this.isUsed = true;
    }

    public boolean used() {
        return this.isUsed;
    }
}

