/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import js.common.CLIToolProgressMonitor;
import js.common.ToolProgressMonitor;
import js.tinyvm.TinyVMException;
import js.tinyvm.TinyVMTool;
import js.tinyvm.util.TinyVMCommandLineParser;
import org.apache.commons.cli.CommandLine;

public class TinyVM
extends TinyVMTool {
    private TinyVMCommandLineParser fParser = new TinyVMCommandLineParser();

    public static void main(String[] args) {
        try {
            TinyVM tinyVM = new TinyVM();
            tinyVM.addProgressMonitor(new CLIToolProgressMonitor());
            tinyVM.start(args);
        }
        catch (TinyVMException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    public void start(String[] args) throws TinyVMException {
        assert (args != null) : "Precondition: args != null";
        CommandLine commandLine = this.fParser.parse(args);
        boolean verbose = commandLine.hasOption("v");
        String classpath = commandLine.getOptionValue("cp");
        String output = commandLine.getOptionValue("o");
        boolean all = commandLine.hasOption("a");
        boolean debug = commandLine.hasOption("g");
        boolean bigEndian = "be".equalsIgnoreCase(commandLine.getOptionValue("wo"));
        String[] classes = commandLine.getArgs();
        for (ToolProgressMonitor monitor : this._monitors) {
            monitor.setVerbose(verbose);
        }
        OutputStream stream = null;
        try {
            stream = output == null ? System.out : new FileOutputStream(output);
            this.link(classpath, classes, all, stream, bigEndian, debug);
        }
        catch (FileNotFoundException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
        finally {
            if (stream instanceof FileOutputStream) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new TinyVMException(e);
                }
            }
        }
    }
}

