/**
 *  BlueCove - Java library for Bluetooth
 *  Copyright (C) 2007 Vlad Skarzhevskyy
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  @version $Id: OSXStackRFCOMMServer.h 1312 2007-12-05 08:08:22Z skarzhevskyy $
 */

#import "OSXStackRFCOMM.h"
#import "OSXStackSDPServer.h"

#import <IOBluetooth/objc/IOBluetoothSDPServiceRecord.h>
#import <IOBluetooth/objc/IOBluetoothSDPUUID.h>

class RFCOMMServerController : public ServerController {
public:

    BluetoothRFCOMMChannelID rfcommChannelID;

    RFCOMMChannelController* acceptClientComm;

    NSMutableDictionary* rfcommChannelIDDataElement;

public:
    RFCOMMServerController();
    virtual ~RFCOMMServerController();

    virtual IOReturn updateSDPServiceRecord();
    IOReturn publish();
    void close();
};

class RFCOMMServicePublish: public Runnable {
public:
    jbyte* uuidValue;
    int uuidValueLength;
    jboolean obexSrv;
    jboolean authenticate;
    jboolean encrypt;
    const jchar *serviceName;
    int serviceNameLength;

    RFCOMMServerController* comm;
    volatile IOReturn status;

    RFCOMMServicePublish();
    virtual void run();
};