/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import lejos.nxt.Flash;

public class FileInputStream
extends InputStream {
    int pointer;
    int page_pointer;
    int data_pointer;
    byte[] buff;
    File file;

    public FileInputStream(File f) {
        this.file = f;
        this.buff = new byte[Flash.BYTES_PER_PAGE];
        this.page_pointer = this.file.page_location;
        this.data_pointer = 0;
        this.pointer = 0;
        Flash.readPage(this.buff, this.page_pointer);
    }

    public int available() throws IOException {
        return this.file.file_length - this.pointer;
    }

    public int read() throws IOException {
        if (this.available() <= 0) {
            return -1;
        }
        byte val = this.buff[this.data_pointer];
        ++this.data_pointer;
        ++this.pointer;
        if (this.data_pointer >= Flash.BYTES_PER_PAGE) {
            this.data_pointer = 0;
            ++this.page_pointer;
            Flash.readPage(this.buff, this.page_pointer);
        }
        return val & 0xFF;
    }

    public void reset() {
        this.page_pointer = this.file.page_location;
        this.data_pointer = 0;
        this.pointer = 0;
        Flash.readPage(this.buff, this.page_pointer);
    }
}

