/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Integer {
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 0x7FFFFFFF;
    public static final int MIN_RADIX = 2;
    public static final int MAX_RADIX = 36;
    private static int LOWER_LIMIT = 48;
    private static int UPPER_LIMIT = 57;
    private static int LOWER_CHAR = 65;
    private static int UPPER_CHAR = 90;
    private int value;
    static char[] buf = new char[12];

    public Integer(int value) {
        this.value = value;
    }

    public static int parseInt(String s, int radix) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException();
        }
        if (radix < 2) {
            throw new NumberFormatException();
        }
        if (radix > 36) {
            throw new NumberFormatException();
        }
        int result = 0;
        boolean negative = false;
        int i = 0;
        int len = s.length();
        int limit = -2147483647;
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Integer.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw new NumberFormatException();
                }
                if (len == 1) {
                    throw new NumberFormatException();
                }
                ++i;
            }
            int multmin = limit / radix;
            while (i < len) {
                int digit;
                if ((digit = Integer.digit(s.charAt(i++), radix)) < 0) {
                    throw new NumberFormatException();
                }
                if (result < multmin) {
                    throw new NumberFormatException();
                }
                if ((result *= radix) < limit + digit) {
                    throw new NumberFormatException();
                }
                result -= digit;
            }
        } else {
            throw new NumberFormatException();
        }
        return negative ? result : -result;
    }

    public static int parseInt(String s) throws NumberFormatException {
        return Integer.parseInt(s, 10);
    }

    public static int digit(char ch, int radix) {
        return Integer.digit((int)ch, radix);
    }

    public static int digit(int codePoint, int radix) {
        int val = codePoint;
        if (codePoint >= LOWER_LIMIT & codePoint <= UPPER_LIMIT) {
            val -= LOWER_LIMIT;
        } else if (codePoint >= LOWER_CHAR & codePoint <= UPPER_CHAR) {
            val = val - LOWER_CHAR + 10;
        }
        if (val < radix & val >= 0) {
            return val;
        }
        throw new NumberFormatException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(int i) {
        char[] cArray = buf;
        synchronized (buf) {
            int q;
            int charPos = 12;
            int sign = 0;
            if (i == Integer.MIN_VALUE) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return "-2147483648";
            }
            if (i < 0) {
                sign = 45;
                i = -i;
            }
            do {
                q = i / 10;
                int r = i - q * 10;
                Integer.buf[--charPos] = (char)(48 + r);
            } while ((i = q) != 0);
            if (sign != 0) {
                Integer.buf[--charPos] = sign;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new String(buf, charPos, 12 - charPos);
        }
    }

    public String toString() {
        return Integer.toString(this.value);
    }
}

