/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Enumeration;
import java.util.Vector;

public class Hashtable {
    private static final int TABLE_SIZE = 32;
    private Object[] iTable = new Object[32];

    public synchronized Object get(Object aKey) {
        Object pElement = this.iTable[this.getTableIndex(aKey)];
        if (pElement == null) {
            return null;
        }
        KeyValuePair pKeyValuePair = this.getKeyValuePair(pElement, aKey);
        if (pKeyValuePair == null) {
            return null;
        }
        return pKeyValuePair.iValue;
    }

    public synchronized void put(Object aKey, Object aValue) {
        int pIndex = this.getTableIndex(aKey);
        Object pElement = this.iTable[pIndex];
        KeyValuePair pKeyValuePair = null;
        if (pElement != null) {
            pKeyValuePair = this.getKeyValuePair(pElement, aKey);
        }
        if (pKeyValuePair == null) {
            pKeyValuePair = new KeyValuePair();
            pKeyValuePair.iKey = aKey;
            pKeyValuePair.iValue = aValue;
        }
        if (pElement == null) {
            this.iTable[pIndex] = pKeyValuePair;
        } else if (pElement == pKeyValuePair) {
            pKeyValuePair.iValue = aValue;
        } else if (pElement instanceof KeyValuePair) {
            Vector pVector = new Vector();
            pVector.addElement(pElement);
            pVector.addElement(pKeyValuePair);
            this.iTable[pIndex] = pVector;
        } else {
            ((Vector)pElement).addElement(pKeyValuePair);
        }
    }

    public Enumeration keys() {
        return new Enumeration(){
            int cur = 0;
            int curVector = -1;

            public boolean hasMoreElements() {
                Vector v;
                int i = this.cur;
                if (i < 32 && Hashtable.this.iTable[i] instanceof Vector && this.curVector + 1 >= (v = (Vector)Hashtable.this.iTable[i]).size()) {
                    ++i;
                }
                while (i < 32) {
                    if (Hashtable.this.iTable[i] != null) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }

            public Object nextElement() {
                while (this.cur < 32) {
                    if (Hashtable.this.iTable[this.cur] instanceof KeyValuePair) {
                        KeyValuePair kvp = (KeyValuePair)Hashtable.this.iTable[this.cur];
                        ++this.cur;
                        if (kvp != null) {
                            return kvp.iKey;
                        }
                    } else if (Hashtable.this.iTable[this.cur] instanceof Vector) {
                        ++this.curVector;
                        while (this.curVector >= 0) {
                            Vector v = (Vector)Hashtable.this.iTable[this.cur];
                            if (this.curVector >= v.size()) {
                                this.curVector = -1;
                                break;
                            }
                            KeyValuePair kvp = (KeyValuePair)v.elementAt(this.curVector);
                            if (kvp == null) {
                                this.curVector = -1;
                                continue;
                            }
                            return kvp.iKey;
                        }
                    }
                    ++this.cur;
                }
                return null;
            }
        };
    }

    private KeyValuePair getKeyValuePair(Object aPivot, Object aKey) {
        if (aPivot instanceof Vector) {
            Vector pVec = (Vector)aPivot;
            int pSize = pVec.size();
            for (int i = 0; i < pSize; ++i) {
                KeyValuePair pPair = (KeyValuePair)pVec.elementAt(i);
                if (!aKey.equals(pPair.iKey)) continue;
                return pPair;
            }
            return null;
        }
        KeyValuePair pPair = (KeyValuePair)aPivot;
        if (aKey.equals(pPair.iKey)) {
            return pPair;
        }
        return null;
    }

    private int getTableIndex(Object aKey) {
        int pHash = aKey.hashCode();
        if (pHash < 0) {
            pHash = -pHash;
        }
        return pHash % 32;
    }

    private static class KeyValuePair {
        Object iKey;
        Object iValue;

        private KeyValuePair() {
        }
    }
}

