/*
 * Decompiled with CFR 0.152.
 */
package lejos.devices;

import java.io.IOException;
import java.io.InputStream;
import lejos.devices.NMEASentence;
import lejos.nxt.comm.RConsole;

public class GPS
extends Thread {
    private final int BUFF = 20;
    private byte[] segment = new byte[20];
    private StringBuffer currentSentence = new StringBuffer();
    private String START_CHAR = "$";
    private String GGA_STR = "GGA";
    private InputStream in;
    private String BLANK = "";
    private int time = 0;
    private float latitude = 0.0f;
    private float longitude = 0.0f;
    private float altitude = 0.0f;
    private byte satellites_tracked = 0;

    public GPS(InputStream in) {
        this.in = in;
        this.setDaemon(true);
        this.start();
    }

    public float getLatitude() {
        return this.latitude;
    }

    public float getLongitude() {
        return this.longitude;
    }

    public float getAltitude() {
        return this.altitude;
    }

    public int getTime() {
        return this.time;
    }

    public byte getSatellitesTracked() {
        return this.satellites_tracked;
    }

    public int getHeading() {
        return -1;
    }

    public int getSpeed() {
        return -1;
    }

    public void addGPSListener() {
    }

    public void setOriginPoint(String longitude, String latitude) {
    }

    public void run() {
        while (true) {
            String s;
            if ((s = this.getNextString()).indexOf(42) < 0) {
                RConsole.print("Error no * caught!\n");
                RConsole.print("String: " + s + "\n");
                continue;
            }
            if (s.indexOf(36) < 0) {
                RConsole.print("Error no $ caught!\n");
                RConsole.print("String: " + s + "\n");
                continue;
            }
            NMEASentence sen = new NMEASentence(s);
            RConsole.print("String: " + s + "\n");
            if (!sen.isValid() || !sen.getDataType().equals(this.GGA_STR)) continue;
            this.latitude = Float.parseFloat((String)sen.getDataFields().elementAt(1));
            this.longitude = Float.parseFloat((String)sen.getDataFields().elementAt(3));
            this.altitude = Float.parseFloat((String)sen.getDataFields().elementAt(7));
        }
    }

    private String getNextString() {
        boolean done = false;
        do {
            try {
                this.in.read(this.segment);
            }
            catch (IOException e) {
                // empty catch block
            }
            for (int i = 0; i < 20; ++i) {
                this.currentSentence.append((char)this.segment[i]);
            }
            if (this.currentSentence.indexOf(this.START_CHAR, 1) < 0) continue;
            done = true;
        } while (!done);
        int endIndex = this.currentSentence.indexOf(this.START_CHAR, 1);
        String sentence = this.currentSentence.substring(0, endIndex);
        this.currentSentence.delete(0, endIndex);
        return sentence;
    }
}

