/*
 * Decompiled with CFR 0.152.
 */
package lejos.navigation;

import lejos.navigation.Pilot;
import lejos.nxt.CompassSensor;
import lejos.nxt.Motor;
import lejos.nxt.SensorPort;

public class CompassPilot
extends Pilot {
    protected CompassSensor compass;
    private Regulator regulator = new Regulator();
    private int _heading;
    private boolean _traveling = false;
    private boolean _rotating = false;
    private float _distance;

    public boolean isRotating() {
        return this._rotating;
    }

    public boolean isTraveling() {
        return this._traveling;
    }

    public CompassPilot(SensorPort compassPort, float wheelDiameter, float trackWidth, Motor leftMotor, Motor rightMotor) {
        this(compassPort, wheelDiameter, trackWidth, leftMotor, rightMotor, false);
    }

    public CompassPilot(SensorPort compassPort, float wheelDiameter, float trackWidth, Motor leftMotor, Motor rightMotor, boolean reverse) {
        this(new CompassSensor(compassPort), wheelDiameter, trackWidth, leftMotor, rightMotor, reverse);
    }

    public CompassPilot(CompassSensor compass, float wheelDiameter, float trackWidth, Motor leftMotor, Motor rightMotor) {
        this(compass, wheelDiameter, trackWidth, leftMotor, rightMotor, false);
    }

    public CompassPilot(CompassSensor compass, float wheelDiameter, float trackWidth, Motor leftMotor, Motor rightMotor, boolean reverse) {
        super(wheelDiameter, trackWidth, leftMotor, rightMotor, reverse);
        this.compass = compass;
        this._heading = (int)compass.getDegreesCartesian();
        this.regulator.setDaemon(true);
        this.regulator.start();
    }

    public CompassSensor getCompass() {
        return this.compass;
    }

    public int getAngle() {
        return (int)this.compass.getDegreesCartesian();
    }

    public int getHeading() {
        return this._heading;
    }

    public void setHeading(int angle) {
        this._heading = angle;
    }

    public void calibrate() {
        int spd = this._speed;
        this.setSpeed(100);
        this.regulateSpeed(true);
        this.compass.startCalibration();
        super.rotate(360, false);
        this.compass.stopCalibration();
        this.setSpeed(spd);
    }

    private int getHeadingError(int heading) {
        int err = this.getAngle() - heading;
        if (err < -180) {
            err += 360;
        }
        if (err > 180) {
            err -= 360;
        }
        return err;
    }

    public void travel(float distance, boolean immediateReturn) {
        this.regulateSpeed(false);
        this.resetTachoCount();
        this.forward();
        this._distance = distance;
        this._traveling = true;
        if (immediateReturn) {
            return;
        }
        while (this._traveling) {
            Thread.yield();
        }
    }

    public void travel(float distance) {
        this.travel(distance, false);
    }

    public void rotateTo(int angle, boolean immediateReturn) {
        this._heading = angle;
        this._traveling = false;
        this.regulateSpeed(true);
        this._rotating = true;
        if (immediateReturn) {
            return;
        }
        while (this._rotating) {
            Thread.yield();
        }
        this._heading = (int)this.compass.getDegreesCartesian();
    }

    public void rotateTo(int heading) {
        this.rotateTo(heading, false);
    }

    public void rotate(int angle, boolean immediateReturn) {
        super.rotate(angle, immediateReturn);
        if (immediateReturn) {
            return;
        }
        while (this.isMoving()) {
            Thread.yield();
        }
        this.rotateTo(this._heading + angle);
    }

    public void rotate(int angle) {
        this.rotate(angle, false);
    }

    public boolean isMoving() {
        return super.isMoving() || this._rotating || this._traveling;
    }

    private void stopNow() {
        this.stop();
    }

    private boolean pilotIsMoving() {
        return super.isMoving();
    }

    private void performRotation(int angle) {
        if (angle > 180) {
            angle -= 360;
        }
        if (angle < -180) {
            angle += 360;
        }
        if (angle > 5) {
            angle -= 3;
        }
        if (angle < -5) {
            angle += 3;
        }
        super.rotate(angle, true);
    }

    class Regulator
    extends Thread {
        Regulator() {
        }

        public void run() {
            while (true) {
                if (CompassPilot.this.pilotIsMoving() && CompassPilot.this._traveling) {
                    if (CompassPilot.this.getTravelDistance() >= CompassPilot.this._distance) {
                        CompassPilot.this.stopNow();
                        CompassPilot.this._traveling = false;
                    } else {
                        this.controlTravel();
                    }
                }
                if (CompassPilot.this._rotating && !CompassPilot.this.pilotIsMoving()) {
                    int error = CompassPilot.this.getHeadingError(CompassPilot.this._heading);
                    if (Math.abs(error) > 3) {
                        CompassPilot.this.performRotation(-error);
                    } else {
                        CompassPilot.this._rotating = false;
                        CompassPilot.this.stopNow();
                    }
                }
                Thread.yield();
            }
        }

        private void controlTravel() {
            float gain = 2.0f;
            int error = (int)(gain * (float)CompassPilot.this.getHeadingError(CompassPilot.this._heading));
            if (error < 0) {
                if ((error = -error) > 100) {
                    error = 100;
                }
                int slowSpeed = CompassPilot.this._speed * (100 - error) / 100;
                CompassPilot.this._left.setSpeed(slowSpeed);
                CompassPilot.this._right.setSpeed(CompassPilot.this._speed);
            } else {
                if (error > 100) {
                    error = 100;
                }
                int slowSpeed = CompassPilot.this._speed * (100 - error) / 100;
                CompassPilot.this._right.setSpeed(slowSpeed);
                CompassPilot.this._left.setSpeed(CompassPilot.this._speed);
            }
        }
    }
}

