/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import lejos.nxt.BasicMotor;
import lejos.nxt.Battery;
import lejos.nxt.MotorPort;
import lejos.nxt.TachoMotorPort;

public class Motor
extends BasicMotor {
    public TachoMotorPort _port;
    private int _speed = 360;
    private boolean _keepGoing = true;
    private boolean _regulate = true;
    public Regulator regulator = new Regulator();
    private byte _direction = 1;
    private int _limitAngle;
    private int _stopAngle;
    private boolean _rotating = false;
    public boolean _rampUp = true;
    private boolean _useRamp = true;
    private int _lastTacho = 0;
    private int _actualSpeed;
    private float _voltage = 0.0f;
    private boolean _lock = false;
    private int _brakePower = 20;
    private int _lockPower = 30;
    public static final Motor A = new Motor(MotorPort.A);
    public static final Motor B = new Motor(MotorPort.B);
    public static final Motor C = new Motor(MotorPort.C);

    public Motor(TachoMotorPort port) {
        this._port = port;
        port.setPWMMode(1);
        this.regulator.setDaemon(true);
        this.regulator.start();
        this._voltage = Battery.getVoltage();
    }

    public int getStopAngle() {
        return this._stopAngle;
    }

    public void forward() {
        this._rampUp = this._mode == 1 ? false : this._useRamp;
        if (this._mode == 2) {
            this.stop();
        }
        this._direction = 1;
        this.updateState(1);
    }

    public void backward() {
        this._rampUp = this._mode == 2 ? false : this._useRamp;
        if (this._mode == 1) {
            this.stop();
        }
        this.updateState(2);
        this._direction = (byte)-1;
    }

    public void reverseDirection() {
        if (this._mode == 1) {
            this.backward();
        } else if (this._mode == 2) {
            this.forward();
        }
    }

    public void flt() {
        this.updateState(4);
    }

    public void stop() {
        this.updateState(3);
    }

    public void lock(int power) {
        if (power > 100) {
            this._lockPower = 100;
        }
        if (power < 0) {
            this._lockPower = 0;
        }
        this._limitAngle = this.getTachoCount();
        this._lock = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateState(int mode) {
        Regulator regulator = this.regulator;
        synchronized (regulator) {
            this._rotating = false;
            this._lock = false;
            if (this._mode == mode) {
                return;
            }
            this._mode = mode;
            if (this._mode == 3 || this._mode == 4) {
                this._port.controlMotor(0, this._mode);
                if (this._regulate) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return;
            }
            this._port.controlMotor(this._power, this._mode);
            if (this._regulate) {
                this.regulator.reset();
            }
        }
    }

    public boolean isMoving() {
        return this._mode == 1 || this._mode == 2 || this._rotating;
    }

    public void rotate(int angle) {
        this.rotateTo(this.getTachoCount() + angle);
    }

    public void rotate(int angle, boolean immediateReturn) {
        int t = this.getTachoCount();
        this.rotateTo(t + angle, immediateReturn);
    }

    public void rotateTo(int limitAngle) {
        this.rotateTo(limitAngle, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotateTo(int limitAngle, boolean immediateReturn) {
        Regulator regulator = this.regulator;
        synchronized (regulator) {
            this._lock = false;
            this._stopAngle = limitAngle;
            if (limitAngle > this.getTachoCount()) {
                this.forward();
            } else {
                this.backward();
            }
            int os = this.overshoot(limitAngle - this.getTachoCount());
            this._stopAngle -= this._direction * os;
            this._limitAngle = limitAngle;
            this._rotating = true;
        }
        if (immediateReturn) {
            return;
        }
        while (this._rotating) {
            Thread.yield();
        }
    }

    public void shutdown() {
        this._keepGoing = false;
    }

    public void regulateSpeed(boolean yes) {
        this._regulate = yes;
        if (yes) {
            this.regulator.reset();
        }
    }

    public void smoothAcceleration(boolean yes) {
        this._rampUp = yes;
        this._useRamp = yes;
    }

    public void setSpeed(int speed) {
        this._rampUp = speed > this._speed + 300 && this.isMoving() ? this._useRamp : false;
        this._speed = speed;
        if (speed < 0) {
            this._speed = -speed;
        }
        this.setPower(this.regulator.calcPower(this._speed));
        this.regulator.reset();
    }

    public synchronized void setPower(int power) {
        this._power = power;
        this._port.controlMotor(this._power, this._mode);
    }

    public int getSpeed() {
        return this._speed;
    }

    public int getMode() {
        return this._mode;
    }

    public int getPower() {
        return this._power;
    }

    private int overshoot(int angle) {
        float endRamp;
        float ratio = 0.06f;
        if (!this._regulate) {
            ratio = -0.173f + 0.029f * this._voltage;
        }
        if (angle < 0) {
            angle = -angle;
        }
        if ((float)angle < (endRamp = (float)this._speed * 0.15f)) {
            float a = (float)angle / endRamp;
            ratio = 0.052f * (1.0f - (1.0f - a) * (1.0f - a));
        }
        return (int)(ratio * (float)this._speed);
    }

    public int getLimitAngle() {
        return this._limitAngle;
    }

    public boolean isRotating() {
        return this._rotating;
    }

    public boolean isRegulating() {
        return this._regulate;
    }

    private void timedOut() {
        int angle = this.getTachoCount();
        this._actualSpeed = 10 * (angle - this._lastTacho);
        this._lastTacho = angle;
        this._voltage = Battery.getVoltage();
    }

    public int getActualSpeed() {
        return this._actualSpeed;
    }

    public int getTachoCount() {
        return this._port.getTachoCount();
    }

    public void resetTachoCount() {
        this.regulator.reset();
        this._port.resetTachoCount();
    }

    public float getError() {
        return this.regulator.error;
    }

    public float getBasePower() {
        return this.regulator.basePower;
    }

    public void setBrakePower(int pwr) {
        this._brakePower = pwr;
    }

    public class Regulator
    extends Thread {
        int angle0 = 0;
        float basePower = 0.0f;
        int time0 = 0;
        float error = 0.0f;
        float e0 = 0.0f;

        int calcPower(int speed) {
            float pwr = 100.0f - 11.0f * Motor.this._voltage + 0.11f * (float)Motor.this._speed;
            if (pwr < 0.0f) {
                return 0;
            }
            if (pwr > 100.0f) {
                return 100;
            }
            return (int)pwr;
        }

        public void reset() {
            Motor.this._lock = false;
            if (!Motor.this._regulate) {
                return;
            }
            this.time0 = (int)System.currentTimeMillis();
            this.angle0 = Motor.this.getTachoCount();
            this.basePower = this.calcPower(Motor.this._speed);
            Motor.this.setPower((int)this.basePower);
            this.e0 = 0.0f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            float power = 0.0f;
            float ts = 120.0f;
            int tick = 100 + (int)System.currentTimeMillis();
            float accel = 0.0f;
            while (Motor.this._keepGoing) {
                Regulator regulator = this;
                synchronized (regulator) {
                    if ((int)System.currentTimeMillis() >= tick) {
                        tick += 100;
                        Motor.this.timedOut();
                    }
                    if (Motor.this._lock) {
                        int tc = Motor.this.getTachoCount();
                        if (tc < Motor.this._limitAngle - 1) {
                            Motor.this._mode = 1;
                            Motor.this._port.controlMotor(Motor.this._lockPower, Motor.this._mode);
                        } else if (tc > Motor.this._limitAngle + 1) {
                            Motor.this._mode = 2;
                            Motor.this._port.controlMotor(Motor.this._lockPower, Motor.this._mode);
                        } else {
                            Motor.this._port.controlMotor(0, 3);
                        }
                    } else if (Motor.this._rotating && Motor.this._direction * (Motor.this.getTachoCount() - Motor.this._stopAngle) >= 0) {
                        this.stopAtLimit();
                    } else if (Motor.this._regulate && Motor.this.isMoving()) {
                        int angle;
                        int elapsed = (int)System.currentTimeMillis() - this.time0;
                        int absA = angle = Motor.this.getTachoCount() - this.angle0;
                        if (angle < 0) {
                            absA = -angle;
                        }
                        if (Motor.this._rampUp) {
                            if ((float)elapsed < ts) {
                                this.error = (float)(elapsed * elapsed * Motor.this._speed) * 0.77f / (ts * 2000.0f);
                                this.error += (float)(elapsed * Motor.this._speed) * 0.15f / 1000.0f;
                                this.error -= (float)absA;
                            } else {
                                this.error = ((float)elapsed - ts / 2.0f) * (float)Motor.this._speed / 1000.0f - (float)absA;
                            }
                        } else {
                            this.error = (float)(elapsed * Motor.this._speed) / 1000.0f - (float)absA;
                        }
                        float gain = 5.0f;
                        float extrap = 4.0f;
                        power = this.basePower + gain * (this.error + extrap * (this.error - this.e0));
                        this.e0 = this.error;
                        if (power < 0.0f) {
                            power = 0.0f;
                        }
                        if (power > 100.0f) {
                            power = 100.0f;
                        }
                        float smooth = 0.012f;
                        this.basePower += smooth * (power - this.basePower);
                        Motor.this.setPower((int)power);
                    }
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ie) {}
            }
        }

        void stopAtLimit() {
            Motor.this._mode = 3;
            Motor.this._port.controlMotor(0, 3);
            int e0 = 0;
            e0 = this.angleAtStop();
            e0 -= Motor.this._limitAngle;
            int k = 0;
            int t1 = 0;
            int error = 0;
            int pwr = Motor.this._brakePower;
            while (k < 40) {
                error = Motor.this._limitAngle - Motor.this.getTachoCount();
                if (error == e0) {
                    if (++t1 > 20) {
                        pwr += 10;
                        t1 = 0;
                    }
                } else {
                    t1 = 0;
                    if (error == 0) {
                        pwr = Motor.this._brakePower;
                    }
                    e0 = error;
                }
                if (error < -1) {
                    Motor.this._mode = 2;
                    Motor.this.setPower(pwr);
                    k = 0;
                } else if (error > 1) {
                    Motor.this._mode = 1;
                    Motor.this.setPower(pwr);
                    k = 0;
                } else {
                    Motor.this._mode = 3;
                    Motor.this._port.controlMotor(0, 3);
                    ++k;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ie) {}
            }
            Motor.this._rotating = false;
            Motor.this.setPower(this.calcPower(Motor.this._speed));
        }

        int angleAtStop() {
            int a0 = Motor.this.getTachoCount();
            boolean turning = true;
            int a = 0;
            while (turning) {
                Motor.this._port.controlMotor(0, 3);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException w) {
                    // empty catch block
                }
                a = Motor.this.getTachoCount();
                turning = a != a0;
                a0 = a;
            }
            return a;
        }
    }
}

