/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.remote;

import java.io.IOException;
import lejos.nxt.ADSensorPort;
import lejos.nxt.comm.InputValues;
import lejos.nxt.comm.NXTCommand;
import lejos.nxt.comm.NXTProtocol;

public class RemoteSensorPort
implements NXTProtocol,
ADSensorPort {
    private int id;
    private int type;
    private int mode;
    private NXTCommand nxtCommand;

    public RemoteSensorPort(NXTCommand nxtCommand, int id) {
        this.nxtCommand = nxtCommand;
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public int getMode() {
        return this.mode;
    }

    public void setTypeAndMode(int type, int mode) {
        this.type = type;
        this.mode = mode;
        try {
            this.nxtCommand.setInputMode(this.id, type, mode);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setType(int type) {
        this.type = type;
        this.setTypeAndMode(type, this.mode);
    }

    public void setMode(int mode) {
        this.mode = mode;
        this.setTypeAndMode(this.type, mode);
    }

    public boolean readBooleanValue() {
        try {
            InputValues vals = this.nxtCommand.getInputValues(this.id);
            return vals.rawADValue < 600;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public int readRawValue() {
        try {
            InputValues vals = this.nxtCommand.getInputValues(this.id);
            return vals.rawADValue;
        }
        catch (IOException ioe) {
            return 0;
        }
    }

    public int readValue() {
        int rawValue = this.readRawValue();
        if (this.mode == 32) {
            return rawValue < 600 ? 1 : 0;
        }
        if (this.mode == 128) {
            return (1023 - rawValue) * 100 / 1023;
        }
        return rawValue;
    }
}

