/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import js.common.AbstractTool;
import js.common.ToolProgressMonitor;
import js.tinyvm.Binary;
import js.tinyvm.ClassPath;
import js.tinyvm.TinyVMException;
import js.tinyvm.io.BEByteWriter;
import js.tinyvm.io.ByteWriter;
import js.tinyvm.io.LEByteWriter;

public class TinyVMTool
extends AbstractTool {
    private static final Logger _logger = Logger.getLogger("TinyVM");

    public void link(String classpath, String[] classes, boolean all, OutputStream stream, boolean bigEndian, boolean debug) throws TinyVMException {
        assert (classpath != null) : "Precondition: classpath != null";
        assert (classes != null) : "Precondition: classes != null";
        assert (stream != null) : "Precondition: stream != null";
        Binary binary = this.link(classpath, classes, all, debug);
        for (ToolProgressMonitor monitor : this._monitors) {
            binary.log(monitor);
        }
        this.dump(binary, stream, bigEndian);
    }

    public Binary link(String classpath, String[] entryClassNames, boolean all, boolean debug) throws TinyVMException {
        assert (classpath != null) : "Precondition: classpath != null";
        assert (entryClassNames != null) : "Precondition: entryClassNames != null";
        if (entryClassNames.length >= 255) {
            throw new TinyVMException("Too many entry classes (max is 254!)");
        }
        if (debug) {
            int names = entryClassNames.length;
            String[] newNames = new String[names + 1];
            System.arraycopy(entryClassNames, 0, newNames, 1, names);
            entryClassNames = newNames;
            entryClassNames[0] = "lejos.nxt.debug.DebugMonitor";
        }
        ClassPath computedClasspath = new ClassPath(classpath);
        for (int i = 0; i < entryClassNames.length; ++i) {
            entryClassNames[i] = entryClassNames[i].replace('.', '/');
        }
        Binary result = Binary.createFromClosureOf(entryClassNames, computedClasspath, all);
        for (int i = 0; i < entryClassNames.length; ++i) {
            if (result.hasMain(entryClassNames[i])) continue;
            throw new TinyVMException("Class " + entryClassNames[i] + " doesn't have a static void main(String[]) method");
        }
        assert (result != null) : "Postconditon: result != null";
        return result;
    }

    public void dump(Binary binary, OutputStream stream, boolean bigEndian) throws TinyVMException {
        assert (binary != null) : "Precondition: binary != null";
        assert (stream != null) : "Precondition: stream != null";
        try {
            BufferedOutputStream bufferedStream = new BufferedOutputStream(stream, 4096);
            ByteWriter byteWriter = bigEndian ? new BEByteWriter(bufferedStream) : new LEByteWriter(bufferedStream);
            binary.dump(byteWriter);
            ((OutputStream)bufferedStream).close();
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }

    static {
        _logger.setLevel(Level.OFF);
    }
}

