/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BluetoothConnectionNotifierParams;
import com.intel.bluetooth.BluetoothConnectionParams;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.DeviceInquiryRunnable;
import com.intel.bluetooth.DeviceInquiryThread;
import com.intel.bluetooth.NativeLibLoader;
import com.intel.bluetooth.NotSupportedIOException;
import com.intel.bluetooth.RemoteDeviceHelper;
import com.intel.bluetooth.SDPInputStream;
import com.intel.bluetooth.SearchServicesDeviceNotReachableException;
import com.intel.bluetooth.SearchServicesException;
import com.intel.bluetooth.SearchServicesRunnable;
import com.intel.bluetooth.SearchServicesTerminatedException;
import com.intel.bluetooth.SearchServicesThread;
import com.intel.bluetooth.ServiceRecordImpl;
import com.intel.bluetooth.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.ServiceRegistrationException;
import javax.bluetooth.UUID;

class BluetoothStackMicrosoft
implements BluetoothStack,
DeviceInquiryRunnable,
SearchServicesRunnable {
    private static final int BTH_MODE_POWER_OFF = 1;
    private static final int BTH_MODE_CONNECTABLE = 2;
    private static final int BTH_MODE_DISCOVERABLE = 3;
    private boolean peerInitialized = false;
    private boolean windowsCE;
    private long localBluetoothAddress = 0L;
    private DiscoveryListener currentDeviceDiscoveryListener;
    private Thread limitedDiscoverableTimer;
    private static final int ATTR_RETRIEVABLE_MAX = 256;
    private static final boolean postponeDeviceDiscoveryReport = true;
    private Vector deviceDiscoveryReportedDevices = new Vector();

    BluetoothStackMicrosoft() {
    }

    public String getStackID() {
        return "winsock";
    }

    public native int getLibraryVersion();

    public native int detectBluetoothStack();

    public native void enableNativeDebug(Class var1, boolean var2);

    private static native int initializationStatus() throws IOException;

    native void uninitialize();

    private native boolean isWindowsCE();

    public void initialize() throws BluetoothStateException {
        try {
            int status = BluetoothStackMicrosoft.initializationStatus();
            DebugLog.debug("initializationStatus", status);
            if (status == 1) {
                this.peerInitialized = true;
            }
            this.windowsCE = this.isWindowsCE();
        }
        catch (BluetoothStateException e) {
            throw e;
        }
        catch (IOException e) {
            DebugLog.fatal("initialization", e);
            throw new BluetoothStateException(e.getMessage());
        }
    }

    public void destroy() {
        if (this.peerInitialized) {
            this.peerInitialized = false;
            this.uninitialize();
        }
        this.cancelLimitedDiscoverableTimer();
    }

    public void initialized() throws BluetoothStateException {
        if (!this.peerInitialized) {
            throw new BluetoothStateException("Bluetooth system is unavailable");
        }
    }

    public int getFeatureSet() {
        return 2 | (this.windowsCE ? 0 : 4);
    }

    private native int getDeviceClass(long var1);

    private native void setDiscoverable(boolean var1) throws BluetoothStateException;

    private native int getBluetoothRadioMode();

    private native String getradioname(long var1);

    private native int getDeviceVersion(long var1);

    private native int getDeviceManufacturer(long var1);

    public String getLocalDeviceBluetoothAddress() {
        try {
            long socket = this.socket(false, false);
            this.bind(socket);
            this.localBluetoothAddress = this.getsockaddress(socket);
            String address = RemoteDeviceHelper.getBluetoothAddress(this.localBluetoothAddress);
            this.storesockopt(socket);
            this.close(socket);
            return address;
        }
        catch (IOException e) {
            DebugLog.error("get local bluetoothAddress", e);
            return "000000000000";
        }
    }

    public String getLocalDeviceName() {
        if (this.localBluetoothAddress == 0L) {
            this.getLocalDeviceBluetoothAddress();
        }
        return this.getradioname(this.localBluetoothAddress);
    }

    public String getRemoteDeviceFriendlyName(long address) throws IOException {
        return this.getpeername(address);
    }

    public DeviceClass getLocalDeviceClass() {
        return new DeviceClass(this.getDeviceClass(this.localBluetoothAddress));
    }

    public void setLocalDeviceServiceClasses(int classOfDevice) {
    }

    private void cancelLimitedDiscoverableTimer() {
        if (this.limitedDiscoverableTimer != null) {
            this.limitedDiscoverableTimer.interrupt();
            this.limitedDiscoverableTimer = null;
        }
    }

    public boolean setLocalDeviceDiscoverable(int mode) throws BluetoothStateException {
        switch (mode) {
            case 0: {
                this.cancelLimitedDiscoverableTimer();
                DebugLog.debug("setDiscoverable(false)");
                this.setDiscoverable(false);
                return 0 == this.getLocalDeviceDiscoverable();
            }
            case 10390323: {
                this.cancelLimitedDiscoverableTimer();
                DebugLog.debug("setDiscoverable(true)");
                this.setDiscoverable(true);
                return 10390323 == this.getLocalDeviceDiscoverable();
            }
            case 10390272: {
                this.cancelLimitedDiscoverableTimer();
                DebugLog.debug("setDiscoverable(LIAC)");
                this.setDiscoverable(true);
                if (10390323 != this.getLocalDeviceDiscoverable()) {
                    return false;
                }
                this.limitedDiscoverableTimer = Utils.schedule(60000L, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            BluetoothStackMicrosoft.this.setDiscoverable(false);
                        }
                        catch (BluetoothStateException e) {
                            DebugLog.debug("error setDiscoverable", e);
                        }
                        finally {
                            BluetoothStackMicrosoft.this.limitedDiscoverableTimer = null;
                        }
                    }
                });
                return true;
            }
        }
        return false;
    }

    public boolean isLocalDevicePowerOn() {
        int mode = this.getBluetoothRadioMode();
        if (mode == 1) {
            return false;
        }
        return mode == 2 || mode == 3;
    }

    public int getLocalDeviceDiscoverable() {
        int mode = this.getBluetoothRadioMode();
        if (mode == 3) {
            if (this.limitedDiscoverableTimer != null) {
                DebugLog.debug("Discoverable = LIAC");
                return 10390272;
            }
            DebugLog.debug("Discoverable = GIAC");
            return 10390323;
        }
        DebugLog.debug("Discoverable = NOT_DISCOVERABLE");
        return 0;
    }

    public String getLocalDeviceProperty(String property) {
        String TRUE = "true";
        String FALSE = "false";
        if ("bluetooth.connected.devices.max".equals(property)) {
            return "7";
        }
        if ("bluetooth.sd.trans.max".equals(property)) {
            return "1";
        }
        if ("bluetooth.connected.inquiry.scan".equals(property)) {
            return "true";
        }
        if ("bluetooth.connected.page.scan".equals(property)) {
            return "true";
        }
        if ("bluetooth.connected.inquiry".equals(property)) {
            return "true";
        }
        if ("bluetooth.connected.page".equals(property)) {
            return "true";
        }
        if ("bluetooth.sd.attr.retrievable.max".equals(property)) {
            return String.valueOf(256);
        }
        if ("bluetooth.master.switch".equals(property)) {
            return "false";
        }
        if ("bluetooth.l2cap.receiveMTU.max".equals(property)) {
            return "0";
        }
        if ("bluecove.radio.version".equals(property)) {
            return String.valueOf(this.getDeviceVersion(this.localBluetoothAddress));
        }
        if ("bluecove.radio.manufacturer".equals(property)) {
            return String.valueOf(this.getDeviceManufacturer(this.localBluetoothAddress));
        }
        return null;
    }

    public boolean isCurrentThreadInterruptedCallback() {
        return Thread.interrupted();
    }

    public void deviceDiscoveredCallback(DiscoveryListener listener, long deviceAddr, int deviceClass, String deviceName, boolean paired) {
        RemoteDevice remoteDevice = RemoteDeviceHelper.createRemoteDevice(this, deviceAddr, deviceName, paired);
        if (this.currentDeviceDiscoveryListener == null || this.currentDeviceDiscoveryListener != listener) {
            return;
        }
        DeviceClass cod = new DeviceClass(deviceClass);
        DebugLog.debug("deviceDiscoveredCallback address", remoteDevice.getBluetoothAddress());
        DebugLog.debug("deviceDiscoveredCallback deviceClass", cod);
        ReportedDevice rd = new ReportedDevice();
        rd.deviceClass = cod;
        rd.remoteDevice = remoteDevice;
        this.deviceDiscoveryReportedDevices.addElement(rd);
    }

    public boolean startInquiry(int accessCode, DiscoveryListener listener) throws BluetoothStateException {
        this.initialized();
        if (this.currentDeviceDiscoveryListener != null) {
            throw new BluetoothStateException("Another inquiry already running");
        }
        this.currentDeviceDiscoveryListener = listener;
        return DeviceInquiryThread.startInquiry(this, accessCode, listener);
    }

    private native boolean cancelInquiry();

    public boolean cancelInquiry(DiscoveryListener listener) {
        if (this.currentDeviceDiscoveryListener != listener) {
            return false;
        }
        this.currentDeviceDiscoveryListener = null;
        return this.cancelInquiry();
    }

    private native int runDeviceInquiryImpl(DeviceInquiryThread var1, int var2, DiscoveryListener var3) throws BluetoothStateException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runDeviceInquiry(DeviceInquiryThread startedNotify, int accessCode, DiscoveryListener listener) throws BluetoothStateException {
        try {
            this.deviceDiscoveryReportedDevices.removeAllElements();
            int discType = this.runDeviceInquiryImpl(startedNotify, accessCode, listener);
            if (discType == 0) {
                Enumeration en = this.deviceDiscoveryReportedDevices.elements();
                while (en.hasMoreElements()) {
                    ReportedDevice rd = (ReportedDevice)en.nextElement();
                    listener.deviceDiscovered(rd.remoteDevice, rd.deviceClass);
                }
            }
            int n = discType;
            return n;
        }
        finally {
            this.currentDeviceDiscoveryListener = null;
        }
    }

    public native int[] runSearchServices(UUID[] var1, long var2) throws SearchServicesException;

    public native byte[] getServiceAttributes(int[] var1, long var2, int var4) throws IOException;

    public int searchServices(int[] attrSet, UUID[] uuidSet, RemoteDevice device, DiscoveryListener listener) throws BluetoothStateException {
        return SearchServicesThread.startSearchServices(this, attrSet, uuidSet, device, listener);
    }

    public int runSearchServices(SearchServicesThread startedNotify, int[] attrSet, UUID[] uuidSet, RemoteDevice device, DiscoveryListener listener) throws BluetoothStateException {
        int[] handles;
        startedNotify.searchServicesStartedCallback();
        try {
            handles = this.runSearchServices(uuidSet, RemoteDeviceHelper.getAddress(device));
        }
        catch (SearchServicesDeviceNotReachableException e) {
            return 6;
        }
        catch (SearchServicesTerminatedException e) {
            return 2;
        }
        catch (SearchServicesException e) {
            return 3;
        }
        if (handles == null) {
            return 3;
        }
        if (handles.length > 0) {
            ServiceRecord[] records = new ServiceRecordImpl[handles.length];
            boolean hasError = false;
            for (int i = 0; i < handles.length; ++i) {
                records[i] = new ServiceRecordImpl(this, device, handles[i]);
                try {
                    records[i].populateRecord(new int[]{0, 1, 2, 3, 4});
                    if (attrSet != null) {
                        records[i].populateRecord(attrSet);
                    }
                }
                catch (Exception e) {
                    DebugLog.debug("populateRecord error", e);
                    hasError = true;
                }
                if (!startedNotify.isTerminated()) continue;
                return 2;
            }
            listener.servicesDiscovered(startedNotify.getTransID(), records);
            if (hasError) {
                return 3;
            }
            return 1;
        }
        return 4;
    }

    public boolean cancelServiceSearch(int transID) {
        SearchServicesThread sst = SearchServicesThread.getServiceSearchThread(transID);
        if (sst != null) {
            sst.setTerminated();
            return true;
        }
        return false;
    }

    public boolean populateServicesRecordAttributeValues(ServiceRecordImpl serviceRecord, int[] attrIDs) throws IOException {
        if (attrIDs.length > 256) {
            throw new IllegalArgumentException();
        }
        byte[] blob = this.getServiceAttributes(attrIDs, RemoteDeviceHelper.getAddress(serviceRecord.getHostDevice()), (int)serviceRecord.getHandle());
        if (blob.length > 0) {
            try {
                boolean anyRetrived = false;
                DataElement element = new SDPInputStream(new ByteArrayInputStream(blob)).readElement();
                Enumeration e = (Enumeration)element.getValue();
                block3: while (e.hasMoreElements()) {
                    int attrID = (int)((DataElement)e.nextElement()).getLong();
                    serviceRecord.populateAttributeValue(attrID, (DataElement)e.nextElement());
                    if (anyRetrived) continue;
                    for (int i = 0; i < attrIDs.length; ++i) {
                        if (attrIDs[i] != attrID) continue;
                        anyRetrived = true;
                        continue block3;
                    }
                }
                return anyRetrived;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new IOException();
            }
        }
        return false;
    }

    private native long socket(boolean var1, boolean var2) throws IOException;

    private native long getsockaddress(long var1) throws IOException;

    private native void storesockopt(long var1);

    private native int getsockchannel(long var1) throws IOException;

    private native void connect(long var1, long var3, int var5) throws IOException;

    public int getSecurityOpt(long handle, int expected) throws IOException {
        return expected;
    }

    private native void bind(long var1) throws IOException;

    private native void listen(long var1) throws IOException;

    private native long accept(long var1) throws IOException;

    private native int recvAvailable(long var1) throws IOException;

    private native int recv(long var1) throws IOException;

    private native int recv(long var1, byte[] var3, int var4, int var5) throws IOException;

    private native void send(long var1, int var3) throws IOException;

    private native void send(long var1, byte[] var3, int var4, int var5) throws IOException;

    private native void close(long var1) throws IOException;

    private native String getpeername(long var1) throws IOException;

    private native long getpeeraddress(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long connectionRfOpenClientConnection(BluetoothConnectionParams params) throws IOException {
        long socket = this.socket(params.authenticate, params.encrypt);
        boolean success = false;
        try {
            this.connect(socket, params.address, params.channel);
            success = true;
        }
        finally {
            if (!success) {
                this.close(socket);
            }
        }
        return socket;
    }

    public void connectionRfCloseClientConnection(long handle) throws IOException {
        this.close(handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long rfServerOpen(BluetoothConnectionNotifierParams params, ServiceRecordImpl serviceRecord) throws IOException {
        long socket = this.socket(params.authenticate, params.encrypt);
        boolean success = false;
        try {
            this.bind(socket);
            this.listen(socket);
            int channel = this.getsockchannel(socket);
            DebugLog.debug("service channel ", channel);
            long serviceRecordHandle = socket;
            serviceRecord.populateRFCOMMAttributes(serviceRecordHandle, channel, params.uuid, params.name, params.obex);
            serviceRecord.setHandle(this.registerService(serviceRecord.toByteArray(), serviceRecord.deviceServiceClasses));
            success = true;
        }
        finally {
            if (!success) {
                this.close(socket);
            }
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rfServerClose(long handle, ServiceRecordImpl serviceRecord) throws IOException {
        try {
            this.close(handle);
        }
        finally {
            this.unregisterService(serviceRecord.getHandle());
        }
    }

    private native long registerService(byte[] var1, int var2) throws ServiceRegistrationException;

    private native void unregisterService(long var1) throws ServiceRegistrationException;

    public long rfServerAcceptAndOpenRfServerConnection(long handle) throws IOException {
        return this.accept(handle);
    }

    public void rfServerUpdateServiceRecord(long handle, ServiceRecordImpl serviceRecord, boolean acceptAndOpen) throws ServiceRegistrationException {
        byte[] blob;
        this.unregisterService(serviceRecord.getHandle());
        try {
            blob = serviceRecord.toByteArray();
        }
        catch (IOException e) {
            throw new ServiceRegistrationException(e.toString());
        }
        serviceRecord.setHandle(this.registerService(blob, serviceRecord.deviceServiceClasses));
        DebugLog.debug("new serviceRecord", serviceRecord);
    }

    public void connectionRfCloseServerConnection(long handle) throws IOException {
        this.connectionRfCloseClientConnection(handle);
    }

    public long getConnectionRfRemoteAddress(long handle) throws IOException {
        return this.getpeeraddress(handle);
    }

    public int connectionRfRead(long handle) throws IOException {
        return this.recv(handle);
    }

    public int connectionRfRead(long handle, byte[] b, int off, int len) throws IOException {
        return this.recv(handle, b, off, len);
    }

    public int connectionRfReadAvailable(long handle) throws IOException {
        return this.recvAvailable(handle);
    }

    public void connectionRfWrite(long handle, int b) throws IOException {
        this.send(handle, b);
    }

    public void connectionRfWrite(long handle, byte[] b, int off, int len) throws IOException {
        this.send(handle, b, off, len);
    }

    public void connectionRfFlush(long handle) throws IOException {
    }

    public long l2OpenClientConnection(BluetoothConnectionParams params, int receiveMTU, int transmitMTU) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public void l2CloseClientConnection(long handle) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public long l2ServerOpen(BluetoothConnectionNotifierParams params, int receiveMTU, int transmitMTU, ServiceRecordImpl serviceRecord) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public void l2ServerUpdateServiceRecord(long handle, ServiceRecordImpl serviceRecord, boolean acceptAndOpen) throws ServiceRegistrationException {
        throw new ServiceRegistrationException("Not Supported on" + this.getStackID());
    }

    public long l2ServerAcceptAndOpenServerConnection(long handle) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public void l2CloseServerConnection(long handle) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public void l2ServerClose(long handle, ServiceRecordImpl serviceRecord) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public boolean l2Ready(long handle) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public int l2Receive(long handle, byte[] inBuf) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public void l2Send(long handle, byte[] data) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public int l2GetReceiveMTU(long handle) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public int l2GetTransmitMTU(long handle) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    public long l2RemoteAddress(long handle) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    static {
        NativeLibLoader.isAvailable("intelbth");
    }

    private static class ReportedDevice {
        RemoteDevice remoteDevice;
        DeviceClass deviceClass;

        private ReportedDevice() {
        }
    }
}

