/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.obex;

import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.obex.MD5DigestWrapper;
import com.intel.bluetooth.obex.OBEXHeaderSetImpl;
import com.intel.bluetooth.obex.OBEXUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import javax.obex.Authenticator;
import javax.obex.PasswordAuthentication;
import javax.obex.ServerRequestHandler;

class OBEXAuthentication {
    private static byte[] privateKey;
    private static long uniqueTimestamp;
    private static final byte[] column;

    OBEXAuthentication() {
    }

    static byte[] createChallenge(String realm, boolean userID, boolean access) {
        Challenge challenge = new Challenge(realm, userID, access, OBEXAuthentication.createNonce());
        return challenge.write();
    }

    static void handleAuthenticationResponse(OBEXHeaderSetImpl incomingHeaders, Authenticator authenticator, ServerRequestHandler serverHandler) throws IOException {
        Enumeration iter = incomingHeaders.getAuthenticationResponses();
        while (iter.hasMoreElements()) {
            byte[] authResponse = (byte[])iter.nextElement();
            DigestResponse dr = new DigestResponse();
            dr.read(authResponse);
            byte[] password = authenticator.onAuthenticationResponse(dr.userName);
            if (password == null) {
                throw new IOException("authentication request failed");
            }
            MD5DigestWrapper md5 = new MD5DigestWrapper();
            md5.update(dr.nonce);
            md5.update(column);
            md5.update(password);
            if (OBEXAuthentication.equals(dr.requestDigest, md5.digest())) continue;
            if (serverHandler != null) {
                serverHandler.onAuthenticationFailure(dr.userName);
                continue;
            }
            throw new IOException("Authentication failure");
        }
    }

    public static void handleAuthenticationChallenge(OBEXHeaderSetImpl incomingHeaders, OBEXHeaderSetImpl replyHeaders, Authenticator authenticator) throws IOException {
        Enumeration iter = incomingHeaders.getAuthenticationChallenges();
        while (iter.hasMoreElements()) {
            byte[] authChallenge = (byte[])iter.nextElement();
            Challenge challenge = new Challenge(authChallenge);
            PasswordAuthentication pwd = authenticator.onAuthenticationChallenge(challenge.realm, challenge.userID, challenge.access);
            DigestResponse dr = new DigestResponse();
            dr.nonce = challenge.nonce;
            if (challenge.userID) {
                dr.userName = pwd.getUserName();
            }
            MD5DigestWrapper md5 = new MD5DigestWrapper();
            md5.update(dr.nonce);
            md5.update(column);
            md5.update(pwd.getPassword());
            dr.requestDigest = md5.digest();
            replyHeaders.addAuthenticationResponse(dr.write());
        }
    }

    private static synchronized byte[] createNonce() {
        MD5DigestWrapper md5 = new MD5DigestWrapper();
        md5.update(OBEXAuthentication.createTimestamp());
        md5.update(column);
        md5.update(OBEXAuthentication.getPrivateKey());
        return md5.digest();
    }

    static boolean equals(byte[] digest1, byte[] digest2) {
        for (int i = 0; i < 16; ++i) {
            if (digest1[i] == digest2[i]) continue;
            return false;
        }
        return true;
    }

    private static synchronized byte[] getPrivateKey() {
        if (privateKey != null) {
            return privateKey;
        }
        MD5DigestWrapper md5 = new MD5DigestWrapper();
        md5.update(OBEXAuthentication.createTimestamp());
        privateKey = md5.digest();
        return privateKey;
    }

    private static synchronized byte[] createTimestamp() {
        long t = System.currentTimeMillis();
        if (t <= uniqueTimestamp) {
            t = uniqueTimestamp + 1L;
        }
        uniqueTimestamp = t;
        byte[] buf = new byte[8];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = (byte)(t >> (buf.length - 1 << 3));
            t <<= 8;
        }
        return buf;
    }

    static {
        uniqueTimestamp = 0L;
        column = new byte[]{58};
    }

    static class DigestResponse {
        byte[] requestDigest;
        byte[] userName;
        byte[] nonce;

        DigestResponse() {
        }

        byte[] write() {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            buf.write(0);
            buf.write(16);
            buf.write(this.requestDigest, 0, 16);
            if (this.userName != null) {
                buf.write(1);
                buf.write(this.userName.length);
                buf.write(this.userName, 0, this.userName.length);
            }
            buf.write(2);
            buf.write(16);
            buf.write(this.nonce, 0, 16);
            return buf.toByteArray();
        }

        void read(byte[] data) throws IOException {
            int len;
            block5: for (int i = 0; i < data.length; i += len) {
                int tag = data[i] & 0xFF;
                len = data[i + 1] & 0xFF;
                i += 2;
                switch (tag) {
                    case 0: {
                        if (len != 16) {
                            throw new IOException("OBEX Digest Response error in tag request-digest");
                        }
                        this.requestDigest = new byte[16];
                        System.arraycopy(data, i, this.requestDigest, 0, 16);
                        continue block5;
                    }
                    case 1: {
                        this.userName = new byte[len];
                        System.arraycopy(data, i, this.userName, 0, this.userName.length);
                        continue block5;
                    }
                    case 2: {
                        if (len != 16) {
                            throw new IOException("OBEX Digest Response error in tag Nonce");
                        }
                        this.nonce = new byte[16];
                        System.arraycopy(data, i, this.nonce, 0, 16);
                    }
                }
            }
        }
    }

    static class Challenge {
        String realm;
        boolean userID;
        boolean access;
        byte[] nonce;

        Challenge(byte[] data) throws IOException {
            this.read(data);
        }

        Challenge(String realm, boolean userID, boolean access, byte[] nonce) {
            this.realm = realm;
            this.userID = userID;
            this.access = access;
            this.nonce = nonce;
        }

        byte[] write() {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            buf.write(0);
            buf.write(16);
            buf.write(this.nonce, 0, 16);
            byte options = (byte)((this.userID ? 1 : 0) | (!this.access ? 2 : 0));
            buf.write(1);
            buf.write(1);
            buf.write(options);
            if (this.realm != null) {
                int charSetCode;
                byte[] realmArray;
                try {
                    realmArray = OBEXUtils.getUTF16Bytes(this.realm);
                    charSetCode = -1;
                }
                catch (UnsupportedEncodingException e) {
                    try {
                        realmArray = this.realm.getBytes("iso-8859-1");
                    }
                    catch (UnsupportedEncodingException e1) {
                        realmArray = new byte[]{};
                    }
                    charSetCode = 1;
                }
                buf.write(2);
                buf.write(realmArray.length + 1);
                buf.write(charSetCode);
                buf.write(realmArray, 0, realmArray.length);
            }
            return buf.toByteArray();
        }

        void read(byte[] data) throws IOException {
            int len;
            block5: for (int i = 0; i < data.length; i += len) {
                int tag = data[i] & 0xFF;
                len = data[i + 1] & 0xFF;
                i += 2;
                switch (tag) {
                    case 0: {
                        if (len != 16) {
                            throw new IOException("OBEX Digest Challenge error in tag Nonce");
                        }
                        this.nonce = new byte[16];
                        System.arraycopy(data, i, this.nonce, 0, 16);
                        continue block5;
                    }
                    case 1: {
                        byte options = data[i];
                        this.userID = (options & 1) != 0;
                        this.access = (options & 2) == 0;
                        continue block5;
                    }
                    case 2: {
                        int charSetCode = data[i] & 0xFF;
                        byte[] chars = new byte[len - 1];
                        System.arraycopy(data, i + 1, chars, 0, chars.length);
                        if (charSetCode == 255) {
                            this.realm = OBEXUtils.newStringUTF16(chars);
                            continue block5;
                        }
                        if (charSetCode == 0) {
                            this.realm = new String(chars, "ASCII");
                            continue block5;
                        }
                        if (charSetCode <= 9) {
                            this.realm = new String(chars, "ISO-8859-" + charSetCode);
                            continue block5;
                        }
                        DebugLog.error("Unsupported charset code " + charSetCode + " in Challenge");
                        this.realm = new String(chars, 1, len, "ASCII");
                    }
                }
            }
        }
    }
}

