/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.obex;

import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.UtilsJavaSE;
import com.intel.bluetooth.obex.OBEXConnectionParams;
import com.intel.bluetooth.obex.OBEXHeaderSetImpl;
import com.intel.bluetooth.obex.OBEXServerOperation;
import com.intel.bluetooth.obex.OBEXServerOperationGet;
import com.intel.bluetooth.obex.OBEXServerOperationPut;
import com.intel.bluetooth.obex.OBEXSessionBase;
import com.intel.bluetooth.obex.OBEXUtils;
import java.io.EOFException;
import java.io.IOException;
import javax.microedition.io.StreamConnection;
import javax.obex.Authenticator;
import javax.obex.HeaderSet;
import javax.obex.ServerRequestHandler;

class OBEXServerSessionImpl
extends OBEXSessionBase
implements Runnable {
    private ServerRequestHandler handler;
    private boolean isConnected = false;
    private OBEXServerOperation operation;
    private boolean closeRequested = false;
    private volatile boolean delayClose = false;
    private Object canCloseEvent = new Object();

    OBEXServerSessionImpl(StreamConnection connection, ServerRequestHandler handler, Authenticator authenticator, OBEXConnectionParams obexConnectionParams) throws IOException {
        super(connection, obexConnectionParams);
        this.handler = handler;
        this.authenticator = authenticator;
        Thread t = new Thread(this);
        UtilsJavaSE.threadSetDaemon(t);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (!this.isClosed() && !this.closeRequested) {
                if (this.handleRequest()) continue;
                return;
            }
        }
        catch (Throwable e) {
            DebugLog.error("OBEXServerSession error", e);
        }
        finally {
            DebugLog.debug("OBEXServerSession ends");
            try {
                super.close();
            }
            catch (IOException e) {
                DebugLog.debug("OBEXServerSession close error", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.closeRequested = true;
        while (this.delayClose) {
            Object object = this.canCloseEvent;
            synchronized (object) {
                try {
                    if (this.delayClose) {
                        this.canCloseEvent.wait(700L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.delayClose = false;
            }
        }
        if (!this.isClosed()) {
            DebugLog.debug("OBEXServerSession close");
            if (this.operation != null) {
                this.operation.close();
                this.operation = null;
            }
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean handleRequest() throws IOException {
        DebugLog.debug("OBEXServerSession handleRequest");
        this.delayClose = false;
        try {
            b = this.readOperation();
        }
        catch (EOFException e) {
            if (this.isConnected) {
                throw e;
            }
            DebugLog.debug("OBEXServerSession got EOF");
            this.close();
            return false;
        }
        this.delayClose = true;
        try {
            opcode = b[0] & 255;
            v0 = finalPacket = (opcode & 128) != 0;
            if (finalPacket) {
                DebugLog.debug("OBEXServerSession operation finalPacket");
            }
            switch (opcode) {
                case 128: {
                    this.processConnect(b);
                    ** break;
lbl22:
                    // 1 sources

                    break;
                }
                case 129: {
                    this.processDisconnect(b);
                    ** break;
lbl26:
                    // 1 sources

                    break;
                }
                case 2: 
                case 130: {
                    this.processPut(b, finalPacket);
                    ** break;
lbl30:
                    // 1 sources

                    break;
                }
                case 5: 
                case 133: {
                    this.processSetPath(b, finalPacket);
                    ** break;
lbl34:
                    // 1 sources

                    break;
                }
                case 255: {
                    this.processAbort();
                    ** break;
lbl38:
                    // 1 sources

                    break;
                }
                case 3: 
                case 131: {
                    this.processGet(b, finalPacket);
                    ** break;
lbl42:
                    // 1 sources

                    break;
                }
                default: {
                    this.writeOperation(209, null);
                    break;
                }
            }
        }
        finally {
            this.delayClose = false;
        }
        var2_4 = this.canCloseEvent;
        synchronized (var2_4) {
            this.canCloseEvent.notifyAll();
        }
        return true;
    }

    private void processConnect(byte[] b) throws IOException {
        DebugLog.debug("Connect operation");
        if (b[3] != 16) {
            throw new IOException("Unsupported client OBEX version " + b[3]);
        }
        if (b.length < 7) {
            throw new IOException("Corrupted OBEX data");
        }
        int requestedMTU = OBEXUtils.bytesToShort(b[5], b[6]);
        if (requestedMTU < 255) {
            throw new IOException("Invalid MTU " + requestedMTU);
        }
        this.mtu = requestedMTU;
        DebugLog.debug("mtu selected", this.mtu);
        OBEXHeaderSetImpl requestHeaders = OBEXHeaderSetImpl.readHeaders(b, 7);
        this.handleAuthenticationResponse(requestHeaders, this.handler);
        HeaderSet replyHeaders = OBEXSessionBase.createOBEXHeaderSet();
        this.handleAuthenticationChallenge(requestHeaders, (OBEXHeaderSetImpl)replyHeaders);
        int rc = 208;
        try {
            rc = this.handler.onConnect(requestHeaders, replyHeaders);
        }
        catch (Throwable e) {
            DebugLog.error("onConnect", e);
        }
        byte[] connectResponse = new byte[]{16, 0, OBEXUtils.hiByte(this.obexConnectionParams.mtu), OBEXUtils.loByte(this.obexConnectionParams.mtu)};
        this.writeOperation(rc, connectResponse, OBEXHeaderSetImpl.toByteArray(replyHeaders));
        if (rc == 160) {
            this.isConnected = true;
        }
    }

    private boolean validateConnection() throws IOException {
        if (this.isConnected) {
            return true;
        }
        this.writeOperation(192, null);
        return false;
    }

    private void processDisconnect(byte[] b) throws IOException {
        DebugLog.debug("Disconnect operation");
        if (!this.validateConnection()) {
            return;
        }
        OBEXHeaderSetImpl requestHeaders = OBEXHeaderSetImpl.readHeaders(b, 3);
        HeaderSet replyHeaders = OBEXSessionBase.createOBEXHeaderSet();
        int rc = 160;
        try {
            this.handler.onDisconnect(requestHeaders, replyHeaders);
        }
        catch (Throwable e) {
            rc = 211;
            DebugLog.error("onDisconnect", e);
        }
        this.writeOperation(rc, OBEXHeaderSetImpl.toByteArray(replyHeaders));
        this.isConnected = false;
    }

    private boolean processDelete(HeaderSet requestHeaders) throws IOException {
        if (requestHeaders.getHeader(72) == null && requestHeaders.getHeader(73) == null) {
            DebugLog.debug("Delete operation");
            HeaderSet replyHeaders = OBEXSessionBase.createOBEXHeaderSet();
            int rc = 160;
            try {
                rc = this.handler.onDelete(requestHeaders, replyHeaders);
            }
            catch (Throwable e) {
                rc = 211;
                DebugLog.error("onDelete", e);
            }
            this.writeOperation(rc, OBEXHeaderSetImpl.toByteArray(replyHeaders));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPut(byte[] b, boolean finalPacket) throws IOException {
        DebugLog.debug("Put operation");
        if (!this.validateConnection()) {
            return;
        }
        OBEXHeaderSetImpl requestHeaders = OBEXHeaderSetImpl.readHeaders(b, 3);
        if (finalPacket && this.processDelete(requestHeaders)) {
            return;
        }
        try {
            this.operation = new OBEXServerOperationPut(this, requestHeaders, finalPacket);
            int rc = 160;
            try {
                rc = this.handler.onPut(this.operation);
            }
            catch (Throwable e) {
                rc = 211;
                DebugLog.error("onPut", e);
            }
            this.operation.writeResponse(rc);
        }
        finally {
            this.operation.close();
            this.operation = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGet(byte[] b, boolean finalPacket) throws IOException {
        DebugLog.debug("Get operation");
        if (!this.validateConnection()) {
            return;
        }
        OBEXHeaderSetImpl requestHeaders = OBEXHeaderSetImpl.readHeaders(b, 3);
        try {
            this.operation = new OBEXServerOperationGet(this, requestHeaders);
            int rc = 160;
            try {
                rc = this.handler.onGet(this.operation);
            }
            catch (Throwable e) {
                rc = 211;
                DebugLog.error("onGet", e);
            }
            this.operation.writeResponse(rc);
        }
        finally {
            this.operation.close();
            this.operation = null;
        }
    }

    private void processAbort() throws IOException {
        DebugLog.debug("Abort operation");
        if (!this.validateConnection()) {
            return;
        }
        if (this.operation != null) {
            this.operation.close();
            this.operation = null;
        }
        this.writeOperation(160, null);
    }

    private void processSetPath(byte[] b, boolean finalPacket) throws IOException {
        DebugLog.debug("SetPath operation");
        if (!this.validateConnection()) {
            return;
        }
        if (b.length < 5) {
            throw new IOException("Corrupted OBEX data");
        }
        OBEXHeaderSetImpl requestHeaders = OBEXHeaderSetImpl.readHeaders(b, 5);
        boolean backup = (b[3] & 1) != 0;
        boolean create = (b[3] & 2) == 0;
        DebugLog.debug("setPath backup", backup);
        DebugLog.debug("setPath create", create);
        HeaderSet replyHeaders = OBEXSessionBase.createOBEXHeaderSet();
        int rc = 160;
        try {
            rc = this.handler.onSetPath(requestHeaders, replyHeaders, backup, create);
        }
        catch (Throwable e) {
            rc = 211;
            DebugLog.error("onSetPath", e);
        }
        this.writeOperation(rc, OBEXHeaderSetImpl.toByteArray(replyHeaders));
    }
}

