/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.tools;

import javax.swing.JFrame;
import javax.swing.table.AbstractTableModel;
import lejos.pc.comm.FileInfo;

class FileModel
extends AbstractTableModel {
    private static final String[] columnNames = new String[]{"File", "Size", "Start Page", "End Page", "Delete"};
    private static final int NUM_COLUMNS = 5;
    Object[][] fileData;
    int numFiles;
    JFrame frame;

    public FileModel(JFrame frame, FileInfo[] files, int numFiles) {
        this.frame = frame;
        this.setData(files, numFiles);
    }

    public void setData(FileInfo[] files, int numFiles) {
        this.numFiles = numFiles;
        this.fileData = new Object[30][5];
        for (int i = 0; i < numFiles; ++i) {
            this.fileData[i][0] = files[i].fileName;
            this.fileData[i][1] = new Integer(files[i].fileSize);
            this.fileData[i][2] = new Integer(files[i].startPage);
            this.fileData[i][3] = new Integer(files[i].startPage + (files[i].fileSize - 1) / 256);
            this.fileData[i][4] = new Boolean(false);
        }
    }

    public void delete(int row) {
        for (int i = row; i < this.numFiles - 1; ++i) {
            this.fileData[i] = this.fileData[i + 1];
        }
        --this.numFiles;
    }

    public int getRowCount() {
        return this.numFiles;
    }

    public int getColumnCount() {
        return 5;
    }

    public Object getValueAt(int row, int column) {
        return this.fileData[row][column];
    }

    public void setValueAt(Object value, int row, int column) {
        this.fileData[row][column] = value;
    }

    public String getColumnName(int column) {
        return columnNames[column];
    }

    public Class getColumnClass(int column) {
        return this.fileData[0][column].getClass();
    }

    public boolean isCellEditable(int row, int column) {
        return column == 4;
    }
}

