/*
 * Decompiled with CFR 0.152.
 */
package java.util;

public class Vector {
    protected Object[] elementData;
    protected int capacityIncrement;
    protected int elementCount;

    public Vector(int initialCapacity, int capacityIncrement) {
        if (initialCapacity < 0) {
            initialCapacity = 0;
        }
        this.elementData = new Object[initialCapacity];
        this.capacityIncrement = capacityIncrement;
        this.elementCount = 0;
    }

    public Vector(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public Vector() {
        this(7);
    }

    public synchronized void addElement(Object aObj) {
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount] = aObj;
        ++this.elementCount;
    }

    public int capacity() {
        return this.elementData.length;
    }

    public void clear() {
        this.removeAllElements();
    }

    public synchronized Object elementAt(int aIndex) {
        if (aIndex >= 0 && aIndex < this.elementCount) {
            return this.elementData[aIndex];
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public synchronized void ensureCapacity(int minCapacity) {
        this.ensureCapacityHelper(minCapacity);
    }

    private void ensureCapacityHelper(int minCapacity) {
        if (this.elementData.length < minCapacity) {
            int pNewCapacity = this.capacityIncrement > 0 ? this.elementData.length + this.capacityIncrement : this.elementData.length * 2;
            if (pNewCapacity < minCapacity) {
                pNewCapacity = minCapacity;
            }
            Object[] oldData = this.elementData;
            this.elementData = new Object[pNewCapacity];
            Vector.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
    }

    public boolean equals(Object aObj) {
        return super.equals(aObj);
    }

    public synchronized int indexOf(Object aObj) {
        return this.indexOf(aObj, 0);
    }

    public synchronized int indexOf(Object aObj, int aIndex) {
        if (aObj == null) {
            for (int i = aIndex; i < this.elementCount; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = aIndex; i < this.elementCount; ++i) {
                if (!this.elementData[i].equals(aObj)) continue;
                return i;
            }
        }
        return -1;
    }

    public synchronized void insertElementAt(Object aObj, int aIndex) {
        if (aIndex > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.ensureCapacityHelper(this.elementCount + 1);
        for (int i = this.elementCount; i > aIndex; --i) {
            this.elementData[i] = this.elementData[i - 1];
        }
        this.elementData[aIndex] = aObj;
        ++this.elementCount;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public synchronized int lastIndexOf(Object anObject) {
        return this.lastIndexOf(anObject, this.elementCount - 1);
    }

    public synchronized int lastIndexOf(Object anObject, int anIndex) throws ArrayIndexOutOfBoundsException {
        if (anIndex >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (anObject == null) {
            for (int i = anIndex; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = anIndex; i >= 0; --i) {
                if (!anObject.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public void removeAllElements() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    public synchronized boolean removeElement(Object aObj) {
        int index = this.indexOf(aObj);
        if (index >= 0) {
            this.removeElementAt(index);
            return true;
        }
        return false;
    }

    public synchronized void removeElementAt(int aIndex) {
        if (aIndex >= 0 && aIndex < this.elementCount) {
            int j = this.elementCount - aIndex - 1;
            if (j > 0) {
                Vector.arraycopy(this.elementData, aIndex + 1, this.elementData, aIndex, j);
            }
            --this.elementCount;
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.elementData[this.elementCount] = null;
    }

    public synchronized void setElementAt(Object aObj, int aIndex) {
        if (aIndex >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.elementData[aIndex] = aObj;
    }

    public synchronized void setSize(int aSize) {
        if (this.elementCount < aSize) {
            this.ensureCapacityHelper(aSize);
        } else {
            for (int i = aSize; i < this.elementCount; ++i) {
                this.elementData[i] = null;
            }
        }
        this.elementCount = aSize;
    }

    public synchronized int size() {
        return this.elementCount;
    }

    public synchronized Object[] toArray() {
        Object[] result = new Object[this.elementCount];
        Vector.arraycopy(this.elementData, 0, result, 0, this.elementCount);
        return result;
    }

    public synchronized void trimToSize() {
        if (this.elementCount < this.elementData.length) {
            Object[] oldData = this.elementData;
            this.elementData = new Object[this.elementCount];
            Vector.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
    }

    static void arraycopy(Object[] src, int srcoffset, Object[] dest, int destoffset, int length) {
        for (int i = 0; i < length; ++i) {
            dest[i + destoffset] = src[i + srcoffset];
        }
    }
}

