/*
 * Decompiled with CFR 0.152.
 */
package lejos.navigation;

import lejos.navigation.Navigator;
import lejos.navigation.Pilot;
import lejos.nxt.Motor;

public class TachoNavigator
implements Navigator {
    private float _heading = 0.0f;
    private float _x = 0.0f;
    private float _y = 0.0f;
    public Pilot pilot;
    private boolean _updated = false;

    public TachoNavigator(float wheelDiameter, float trackWidth, Motor leftMotor, Motor rightMotor) {
        this.pilot = new Pilot(wheelDiameter, trackWidth, leftMotor, rightMotor);
    }

    public TachoNavigator(float wheelDiameter, float trackWidth, Motor leftMotor, Motor rightMotor, boolean reverse) {
        this.pilot = new Pilot(wheelDiameter, trackWidth, leftMotor, rightMotor, reverse);
    }

    public TachoNavigator(Pilot pilot) {
        this.pilot = pilot;
    }

    public TachoNavigator(float wheelDiameter, float driveLength) {
        this(wheelDiameter, driveLength, Motor.A, Motor.C);
    }

    public float getX() {
        return this._x;
    }

    public float getY() {
        return this._y;
    }

    public float getAngle() {
        return this._heading;
    }

    public void setPosition(float x, float y, float directionAngle) {
        this._x = x;
        this._y = y;
        this._heading = directionAngle;
    }

    public void setSpeed(int speed) {
        this.pilot.setSpeed(speed);
    }

    public void forward() {
        this._updated = false;
        this.pilot.resetTachoCount();
        this.pilot.forward();
    }

    public void backward() {
        this._updated = false;
        this.pilot.resetTachoCount();
        this.pilot.backward();
    }

    public void stop() {
        this.pilot.stop();
        this.updatePosition();
    }

    public boolean isMoving() {
        return this.pilot.isMoving();
    }

    public void travel(float distance) {
        this.travel(distance, false);
    }

    public void travel(float distance, boolean immediateReturn) {
        this._updated = false;
        this.pilot.resetTachoCount();
        this.pilot.travel(distance, immediateReturn);
        if (!immediateReturn) {
            this.updatePosition();
        }
    }

    public void rotateLeft() {
        this._updated = false;
        this.pilot.resetTachoCount();
        this.pilot.steer(200);
    }

    public void rotateRight() {
        this._updated = false;
        this.pilot.resetTachoCount();
        this.pilot.steer(-200);
    }

    public void rotate(float angle) {
        this.rotate(angle, false);
    }

    public void rotate(float angle, boolean immediateReturn) {
        this._updated = false;
        int turnAngle = Math.round(this.normalize(angle));
        this.pilot.resetTachoCount();
        this.pilot.rotate(turnAngle, immediateReturn);
        if (!immediateReturn) {
            this.updatePosition();
        }
    }

    public void rotateTo(float angle) {
        float turnAngle = this.normalize(angle - this._heading);
        this.rotate(turnAngle, false);
    }

    public void rotateTo(float angle, boolean immediateReturn) {
        float turnAngle = this.normalize(angle - this._heading);
        this.rotate(turnAngle, immediateReturn);
    }

    public void goTo(float x, float y) {
        this.rotateTo(this.angleTo(x, y));
        this.travel(this.distanceTo(x, y));
    }

    public void goTo(float x, float y, boolean immediateReturn) {
        this.rotateTo(this.angleTo(x, y));
        this.travel(this.distanceTo(x, y), immediateReturn);
    }

    public float distanceTo(float x, float y) {
        float dx = x - this._x;
        float dy = y - this._y;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public float angleTo(float x, float y) {
        float dx = x - this._x;
        float dy = y - this._y;
        return (float)Math.toDegrees(Math.atan2(dy, dx));
    }

    public void updatePosition() {
        if (this._updated) {
            return;
        }
        try {
            Thread.sleep(70L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        int left = this.pilot.getLeftCount();
        int right = this.pilot.getRightCount();
        if (left == 0 && right == 0) {
            return;
        }
        int outsideRotation = 0;
        int insideRotation = 0;
        int direction = 1;
        if (Math.abs(left) < Math.abs(right)) {
            outsideRotation = right;
            insideRotation = left;
        } else {
            outsideRotation = left;
            insideRotation = right;
            direction = -1;
        }
        float turnAngle = (float)(direction * (outsideRotation - insideRotation)) * this.pilot._wheelDiameter / (2.0f * this.pilot._trackWidth);
        float ratio = 1.0f * (float)insideRotation / (float)outsideRotation;
        float moveAngle = 0.0f;
        float projection = 0.0f;
        float distance = 0.0f;
        boolean approx = false;
        if ((double)ratio > 0.95) {
            float avg = (float)(insideRotation + outsideRotation) / 2.0f;
            distance = avg / this.pilot._degPerDistance;
            projection = (float)Math.toRadians(this._heading + turnAngle / 2.0f);
            approx = true;
        } else {
            float turnRadius = this.pilot._trackWidth / (1.0f - ratio) - this.pilot._trackWidth / 2.0f;
            float radians = (float)Math.toRadians(turnAngle);
            float dx0 = turnRadius * (float)Math.sin(radians);
            float dy0 = turnRadius * (1.0f - (float)Math.cos(radians));
            distance = (float)Math.sqrt(dx0 * dx0 + dy0 * dy0);
            moveAngle = (float)Math.atan2(dy0, dx0);
            approx = false;
            projection = moveAngle + (float)Math.toRadians(this._heading);
        }
        this._heading = this.normalize(this._heading + turnAngle);
        this._x = (float)((double)this._x + (double)distance * Math.cos(projection));
        this._y = (float)((double)this._y + (double)distance * Math.sin(projection));
        if (approx) {
            this._heading += turnAngle / 2.0f;
        }
        this._updated = true;
    }

    public void turn(float radius) {
        this._updated = false;
        this.pilot.resetTachoCount();
        this.pilot.steer(this.turnRate(radius));
    }

    public void turn(float radius, int angle) {
        this.turn(radius, angle, false);
    }

    public void turn(float radius, int angle, boolean immediateReturn) {
        this._updated = false;
        this.pilot.resetTachoCount();
        this.pilot.steer(this.turnRate(radius), angle, immediateReturn);
        if (!immediateReturn) {
            this.updatePosition();
        }
    }

    private float normalize(float angle) {
        float a;
        for (a = angle; a > 180.0f; a -= 360.0f) {
        }
        while (a < -180.0f) {
            a += 360.0f;
        }
        return a;
    }

    private int turnRate(float radius) {
        int direction = 1;
        if (radius < 0.0f) {
            direction = -1;
            radius = -radius;
        }
        float ratio = (2.0f * radius - this.pilot._trackWidth) / (2.0f * radius + this.pilot._trackWidth);
        return Math.round((float)(direction * 100) * (1.0f - ratio));
    }
}

