/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import lejos.nxt.I2CPort;
import lejos.nxt.SensorConstants;

public abstract class I2CSensor
implements SensorConstants {
    I2CPort port;
    int address = 1;
    String version = "        ";
    String productID = "        ";
    String sensorType = "        ";
    char[] versionChars = StringUtils.getCharacters(this.version);
    char[] productIDChars = StringUtils.getCharacters(this.productID);
    char[] sensorTypeChars = StringUtils.getCharacters(this.sensorType);
    byte[] byteBuff = new byte[8];

    public I2CSensor(I2CPort port) {
        this.port = port;
        port.i2cEnable();
        port.setType(10);
    }

    public int getData(int register, byte[] buf, int len) {
        int ret = this.port.i2cStart(this.address, register, len, buf, len, 0);
        if (ret != 0) {
            return ret;
        }
        while (this.port.i2cBusy() != 0) {
            Thread.yield();
        }
        return 0;
    }

    public int sendData(int register, byte[] buf, int len) {
        int ret = this.port.i2cStart(this.address, register, len, buf, len, 1);
        if (ret != 0) {
            return ret;
        }
        while (this.port.i2cBusy() != 0) {
            Thread.yield();
        }
        return 0;
    }

    public String getVersion() {
        int ret = this.getData(0, this.byteBuff, 8);
        for (int i = 0; i < 8; ++i) {
            this.versionChars[i] = ret == 0 ? (int)this.byteBuff[i] : 32;
        }
        return this.version;
    }

    public String getProductID() {
        int ret = this.getData(8, this.byteBuff, 8);
        for (int i = 0; i < 8; ++i) {
            this.productIDChars[i] = ret == 0 ? (int)this.byteBuff[i] : 32;
        }
        return this.productID;
    }

    public String getSensorType() {
        int ret = this.getData(16, this.byteBuff, 8);
        for (int i = 0; i < 8; ++i) {
            this.sensorTypeChars[i] = ret == 0 ? (int)this.byteBuff[i] : 32;
        }
        return this.sensorType;
    }
}

