/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import lejos.nxt.BasicMotor;
import lejos.nxt.Battery;
import lejos.nxt.MotorPort;
import lejos.nxt.TachoMotorPort;
import lejos.util.Timer;
import lejos.util.TimerListener;

public class Motor
extends BasicMotor
implements TimerListener {
    private TachoMotorPort _port;
    private int _speed = 360;
    private int _speed0 = 360;
    private boolean _keepGoing = true;
    private boolean _regulate = true;
    public Regulator regulator = new Regulator();
    private Timer timer = new Timer(100, this);
    private int _direction = 1;
    private int _limitAngle;
    private int _stopAngle;
    private boolean _rotating = false;
    private boolean _wasRotating = false;
    private boolean _rampUp = true;
    private int _lastTacho = 0;
    private int _actualSpeed;
    private boolean _noRamp = false;
    public static final Motor A = new Motor(MotorPort.A);
    public static final Motor B = new Motor(MotorPort.B);
    public static final Motor C = new Motor(MotorPort.C);

    public Motor(MotorPort port) {
        this._port = port;
        this.regulator.start();
        this.regulator.setDaemon(true);
        this.timer.start();
    }

    public int getStopAngle() {
        return this._stopAngle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateState() {
        Regulator regulator = this.regulator;
        synchronized (regulator) {
            if (this._wasRotating) {
                this.setSpeed(this._speed0);
            }
            this._rotating = false;
            this._wasRotating = false;
            if (this._mode > 2) {
                this._port.controlMotor(0, this._mode);
                return;
            }
            this._port.controlMotor(this._power, this._mode);
            if (this._regulate) {
                this.regulator.reset();
                this._rampUp = true;
            }
            this._direction = 3 - 2 * this._mode;
        }
    }

    public final boolean isMoving() {
        return this._mode == 1 || this._mode == 2 || this._rotating;
    }

    public void rotate(int angle) {
        this.rotateTo(this.getTachoCount() + angle);
    }

    public void rotate(int angle, boolean immediateReturn) {
        int t = this.getTachoCount();
        this.rotateTo(t + angle, immediateReturn);
    }

    public void rotateTo(int limitAngle) {
        this.rotateTo(limitAngle, false);
    }

    public void rotateTo(int limitAngle, boolean immediateReturn) {
        this._stopAngle = limitAngle;
        this._mode = limitAngle > this.getTachoCount() ? 1 : 2;
        this._port.controlMotor(this._power, this._mode);
        this._direction = 3 - 2 * this._mode;
        if (this._regulate) {
            this.regulator.reset();
        }
        if (!this._wasRotating) {
            this._stopAngle -= this._direction * this.overshoot();
            this._limitAngle = limitAngle;
        }
        this._rotating = true;
        boolean bl = this._rampUp = !this._noRamp && Math.abs(this._stopAngle - this.getTachoCount()) > 40 && this._speed > 200;
        if (immediateReturn) {
            return;
        }
        while (this.isMoving()) {
            Thread.yield();
        }
    }

    public void shutdown() {
        this._keepGoing = false;
    }

    public void regulateSpeed(boolean yes) {
        this._regulate = yes;
    }

    public void smoothAcceleration(boolean yes) {
        this._noRamp = !yes;
    }

    public final void setSpeed(int speed) {
        this._speed = Math.abs(speed);
        this.setPower(this.regulator.calcPower(this._speed));
        this.regulator.reset();
        this._rampUp = false;
    }

    public synchronized void setPower(int power) {
        this._power = power;
        this._port.controlMotor(this._power, this._mode);
    }

    public final int getSpeed() {
        return this._speed;
    }

    public int getMode() {
        return this._mode;
    }

    public int getPower() {
        return this._power;
    }

    private int overshoot() {
        return (int)((float)this._speed * 0.06f);
    }

    public int getLimitAngle() {
        return this._limitAngle;
    }

    public final boolean isRotating() {
        return this._rotating;
    }

    public void timedOut() {
        int angle = this.getTachoCount();
        this._actualSpeed = 10 * (angle - this._lastTacho);
        this._lastTacho = angle;
    }

    public int getActualSpeed() {
        return this._actualSpeed;
    }

    public int getTachoCount() {
        return this._port.getTachoCount();
    }

    public void resetTachoCount() {
        this._port.resetTachoCount();
    }

    private class Regulator
    extends Thread {
        int angle0 = 0;
        float basePower = 0.0f;
        int time0 = 0;

        private Regulator() {
        }

        int calcPower(int speed) {
            float pwr = 100.0f - 7.4f * Battery.getVoltage() + 0.065f * (float)speed;
            if (pwr < 0.0f) {
                return 0;
            }
            if (pwr > 100.0f) {
                return 100;
            }
            return (int)pwr;
        }

        public void reset() {
            if (!Motor.this._regulate) {
                return;
            }
            this.time0 = (int)System.currentTimeMillis();
            this.angle0 = Motor.this.getTachoCount();
            this.basePower = this.calcPower(Motor.this._speed);
            Motor.this.setPower((int)this.basePower);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int limit = 0;
            float error = 0.0f;
            float e0 = 0.0f;
            float accel = 1.5f;
            int td = 100;
            float ts = 0.0f;
            boolean wasRegulating = true;
            while (Motor.this._keepGoing) {
                Regulator regulator = this;
                synchronized (regulator) {
                    if (Motor.this._regulate && Motor.this.isMoving()) {
                        int elapsed = (int)System.currentTimeMillis() - this.time0;
                        int angle = Motor.this.getTachoCount() - this.angle0;
                        if (Motor.this._rampUp) {
                            ts = (float)Motor.this._speed / accel;
                            if ((float)(elapsed + td) < ts) {
                                error = accel * (float)(elapsed += td) * (float)elapsed / 2000.0f - (float)Math.abs(angle);
                                this.basePower = this.calcPower((int)Math.max((float)elapsed * accel, 400.0));
                            } else {
                                error = ((float)(elapsed + td) - ts / 2.0f) * (float)Motor.this._speed / 1000.0f - (float)Math.abs(angle);
                            }
                        } else {
                            error = (float)(elapsed * Motor.this._speed) / 1000.0f - (float)Math.abs(angle);
                        }
                        float power = this.basePower + 2.0f * error - 1.0f * e0;
                        if (power < 0.0f) {
                            power = 0.0f;
                        }
                        e0 = error;
                        float smooth = 0.0015f;
                        this.basePower += smooth * (power - this.basePower);
                        Motor.this.setPower((int)power);
                    }
                    if (Motor.this._rotating && Motor.this._direction * (Motor.this.getTachoCount() - Motor.this._stopAngle) > -1) {
                        Motor.this._mode = 3;
                        Motor.this._port.controlMotor(0, 3);
                        int a = this.angleAtStop();
                        int remaining = Motor.this._limitAngle - a;
                        if (Motor.this._direction * remaining > 0) {
                            if (!Motor.this._wasRotating) {
                                Motor.this._speed0 = Motor.this._speed;
                                Motor.this.setSpeed(150);
                                Motor.this._wasRotating = true;
                                wasRegulating = Motor.this._regulate;
                                Motor.this._regulate = true;
                                limit = Motor.this._limitAngle;
                            }
                            Motor.this.rotateTo(limit - remaining / 3, true);
                        } else {
                            Motor.this.setSpeed(Motor.this._speed0);
                            Motor.this._mode = 3;
                            Motor.this._port.controlMotor(0, Motor.this._mode);
                            Motor.this._rotating = false;
                            Motor.this._wasRotating = false;
                            Motor.this._regulate = wasRegulating;
                        }
                    }
                }
                Thread.yield();
            }
        }

        int angleAtStop() {
            int a0 = Motor.this.getTachoCount();
            boolean turning = true;
            int a = 0;
            while (turning) {
                Motor.this._port.controlMotor(0, 3);
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException w) {
                    // empty catch block
                }
                a = Motor.this.getTachoCount();
                turning = Math.abs(a - a0) > 0;
                a0 = a;
            }
            return a;
        }
    }
}

