/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.comm;

import lejos.nxt.Battery;
import lejos.nxt.Motor;
import lejos.nxt.MotorPort;
import lejos.nxt.SensorPort;
import lejos.nxt.Sound;
import lejos.nxt.comm.Bluetooth;

public class LCP {
    static byte[] reply = new byte[32];
    static byte[] i2cCommand = new byte[16];
    static byte[] i2cReply = new byte[16];
    static int i2cLen = 0;

    private LCP() {
    }

    public static void emulateCommand(byte[] cmd, int cmdLen) {
        byte mode;
        byte port;
        int i;
        int len = 3;
        for (i = 0; i < 32; ++i) {
            LCP.reply[i] = 0;
        }
        LCP.reply[0] = 2;
        LCP.reply[1] = cmd[1];
        if (cmd[1] == 11) {
            int mv = Battery.getVoltageMilliVolt();
            LCP.reply[3] = LCP.getLSB(mv);
            LCP.reply[4] = LCP.getMSB(mv);
            len = 5;
        }
        if (cmd[1] == 3) {
            Sound.playTone(LCP.getInt(cmd, 2), LCP.getInt(cmd, 4));
        }
        if (cmd[1] == -120) {
            LCP.reply[3] = 2;
            LCP.reply[4] = 1;
            LCP.reply[5] = 3;
            LCP.reply[6] = 1;
            len = 7;
        }
        if (cmd[1] == 6) {
            port = cmd[2];
            Motor m = port == 0 ? Motor.A : (port == 1 ? Motor.B : Motor.C);
            int tacho = m.getTachoCount();
            mode = 0;
            if (m.isMoving()) {
                mode = 1;
            }
            LCP.reply[3] = port;
            LCP.reply[4] = (byte)(m.getSpeed() * 100 / 900);
            LCP.reply[5] = mode;
            LCP.reply[13] = (byte)(tacho & 0xFF);
            LCP.reply[14] = (byte)(tacho >> 8 & 0xFF);
            LCP.reply[15] = (byte)(tacho >> 16 & 0xFF);
            LCP.reply[16] = (byte)(tacho >> 24 & 0xFF);
            len = 25;
        }
        if (cmd[1] == 7) {
            port = cmd[2];
            int raw = SensorPort.PORTS[port].readRawValue();
            int scaled = SensorPort.PORTS[port].readValue();
            int norm = 1024 - raw;
            LCP.reply[3] = port;
            LCP.reply[4] = 1;
            LCP.reply[5] = 0;
            LCP.reply[6] = (byte)SensorPort.PORTS[port].getType();
            LCP.reply[7] = (byte)SensorPort.PORTS[port].getMode();
            LCP.reply[8] = LCP.getLSB(raw);
            LCP.reply[9] = LCP.getMSB(raw);
            LCP.reply[10] = LCP.getLSB(norm);
            LCP.reply[11] = LCP.getMSB(norm);
            LCP.reply[12] = LCP.getLSB(scaled);
            LCP.reply[13] = LCP.getMSB(scaled);
            LCP.reply[14] = 0;
            LCP.reply[15] = 0;
            len = 16;
        }
        if (cmd[1] == 5) {
            port = cmd[2];
            int sensorType = cmd[3] & 0xFF;
            int sensorMode = cmd[4] & 0xFF;
            SensorPort.PORTS[port].setTypeAndMode(sensorType, sensorMode);
        }
        if (cmd[1] == 4) {
            byte motorid = cmd[2];
            byte power = cmd[3];
            int speed = Math.abs(power) * 900 / 100;
            mode = cmd[4];
            byte regMode = cmd[5];
            byte turnRatio = cmd[6];
            byte runState = cmd[7];
            int tacholimit = 0xFF & cmd[8] | (0xFF & cmd[9]) << 8 | (0xFF & cmd[10]) << 16 | (0xFF & cmd[11]) << 24;
            Motor m = null;
            for (int i2 = 0; i2 < 3; ++i2) {
                if (motorid == 0 || motorid < 0 && i2 == 0) {
                    m = Motor.A;
                } else if (motorid == 1 || motorid < 0 && i2 == 1) {
                    m = Motor.B;
                } else if (motorid == 2 || motorid < 0 && i2 == 2) {
                    m = Motor.C;
                }
                m.setSpeed(speed);
                if (power < 0) {
                    tacholimit = -tacholimit;
                }
                if (power == 0) {
                    m.stop();
                }
                if (tacholimit != 0) {
                    m.rotate(tacholimit, true);
                }
                if ((mode | 1) != 0 && power != 0 && tacholimit == 0) {
                    if (power > 0) {
                        m.forward();
                    } else {
                        m.backward();
                    }
                }
                if (motorid >= 0) break;
            }
        }
        if (cmd[1] == 10) {
            MotorPort.resetTachoCountById(cmd[2]);
        }
        if (cmd[1] == 13) {
            len = 7;
        }
        if (cmd[1] == 15) {
            port = cmd[2];
            byte txLen = cmd[3];
            int rxLen = cmd[4];
            SensorPort.i2cEnableById(port);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            int ret = SensorPort.i2cStartById(port, cmd[5] >> 1, cmd[6], rxLen, i2cReply, rxLen, 0);
            while (SensorPort.i2cBusyById(port) != 0) {
                Thread.yield();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            i2cLen = rxLen;
        }
        if (cmd[1] == 16) {
            LCP.reply[3] = (byte)i2cLen;
            for (i = 0; i < 16; ++i) {
                LCP.reply[i + 4] = i2cReply[i];
            }
            len = 20;
            i2cLen = 0;
        }
        if (cmd[1] == 14) {
            LCP.reply[3] = (byte)i2cLen;
            len = 4;
        }
        if (cmd[1] == -122) {
            LCP.reply[2] = -122;
            len = 28;
        }
        if (cmd[1] == -121) {
            LCP.reply[2] = -122;
            len = 28;
        }
        if ((cmd[0] & 0x80) == 0) {
            Bluetooth.sendPacket(reply, len);
        }
    }

    private static int getInt(byte[] cmd, int i) {
        return (cmd[i] & 0xFF) + ((cmd[i + 1] & 0xFF) << 8);
    }

    private static byte getLSB(int i) {
        return (byte)(i & 0xFF);
    }

    private static byte getMSB(int i) {
        return (byte)(i >> 8 & 0xFF);
    }
}

