/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.compiler;

import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.LinkerParam;
import net.sf.antcontrib.cpptasks.ProcessorParam;
import net.sf.antcontrib.cpptasks.TargetInfo;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinker;
import net.sf.antcontrib.cpptasks.compiler.LinkerConfiguration;
import org.apache.tools.ant.BuildException;

public final class CommandLineLinkerConfiguration
implements LinkerConfiguration {
    private String[][] args;
    private String identifier;
    private String[] libraryNames;
    private CommandLineLinker linker;
    private boolean map;
    private ProcessorParam[] params;
    private boolean rebuild;
    private String startupObject;

    public CommandLineLinkerConfiguration(CommandLineLinker linker, String identifier, String[][] args, ProcessorParam[] params, boolean rebuild, boolean map, String[] libraryNames, String startupObject) {
        if (linker == null) {
            throw new NullPointerException("linker");
        }
        if (args == null) {
            throw new NullPointerException("args");
        }
        this.args = (String[][])args.clone();
        this.linker = linker;
        this.params = (ProcessorParam[])params.clone();
        this.rebuild = rebuild;
        this.identifier = identifier;
        this.map = map;
        this.libraryNames = libraryNames == null ? new String[0] : (String[])libraryNames.clone();
        this.startupObject = startupObject;
    }

    public int bid(String filename) {
        return this.linker.bid(filename);
    }

    public String[] getEndArguments() {
        String[] clone = (String[])this.args[1].clone();
        return clone;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String[] getLibraryNames() {
        String[] clone = (String[])this.libraryNames.clone();
        return clone;
    }

    public boolean getMap() {
        return this.map;
    }

    public String getOutputFileName(String inputFile) {
        return this.linker.getOutputFileName(inputFile);
    }

    public LinkerParam getParam(String name) {
        for (int i = 0; i < this.params.length; ++i) {
            if (!name.equals(this.params[i].getName())) continue;
            return (LinkerParam)this.params[i];
        }
        return null;
    }

    public ProcessorParam[] getParams() {
        return this.params;
    }

    public String[] getPreArguments() {
        String[] clone = (String[])this.args[0].clone();
        return clone;
    }

    public boolean getRebuild() {
        return this.rebuild;
    }

    public String getStartupObject() {
        return this.startupObject;
    }

    public void link(CCTask task, TargetInfo linkTarget) throws BuildException {
        String[] sourcePaths = linkTarget.getAllSourcePaths();
        this.linker.link(task, linkTarget.getOutput(), sourcePaths, this);
    }

    public String toString() {
        return this.identifier;
    }
}

