/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import js.tinyvm.Binary;
import js.tinyvm.ClassPath;
import js.tinyvm.ConstantRecord;
import js.tinyvm.InstanceFieldRecord;
import js.tinyvm.MethodRecord;
import js.tinyvm.RecordTable;
import js.tinyvm.Signature;
import js.tinyvm.StaticFieldRecord;
import js.tinyvm.StaticValue;
import js.tinyvm.TinyVMException;
import js.tinyvm.WritableData;
import js.tinyvm.io.IByteWriter;
import js.tinyvm.io.IOUtilities;
import js.tinyvm.util.HashVector;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class ClassRecord
implements WritableData {
    int iIndex = -1;
    String iName;
    int iClassSize = -1;
    JavaClass iCF;
    Binary iBinary;
    final RecordTable iMethodTable = new RecordTable("methods", false, false);
    final RecordTable iInstanceFields = new RecordTable("instance fields", true, false);
    final Hashtable iStaticValues = new Hashtable();
    final Hashtable iStaticFields = new Hashtable();
    final Hashtable iMethods = new Hashtable();
    final Vector iUsedMethods = new Vector();
    int iParentClassIndex;
    int iArrayElementType;
    int iFlags;
    boolean iUseAllMethods = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void useAllMethods() {
        this.iUseAllMethods = true;
    }

    public String getName() {
        return this.iCF.getClassName();
    }

    public int getLength() {
        return IOUtilities.adjustedSize(10, 2);
    }

    public void dump(IByteWriter aOut) throws TinyVMException {
        try {
            int pAllocSize = this.getAllocationSize();
            if (!$assertionsDisabled && pAllocSize == 0) {
                throw new AssertionError((Object)"Check: alloc ok");
            }
            aOut.writeU2(pAllocSize);
            int pMethodTableOffset = this.iMethodTable.getOffset();
            aOut.writeU2(pMethodTableOffset);
            aOut.writeU2(this.iInstanceFields.getOffset());
            int pNumFields = this.iInstanceFields.size();
            if (pNumFields > 255) {
                throw new TinyVMException("Class " + this.iName + ": No more than " + 255 + " fields expected");
            }
            aOut.writeU1(pNumFields);
            int pNumMethods = this.iMethodTable.size();
            if (pNumMethods > 255) {
                throw new TinyVMException("Class " + this.iName + ": No more than " + 255 + " methods expected");
            }
            aOut.writeU1(pNumMethods);
            aOut.writeU1(this.iParentClassIndex);
            aOut.writeU1(this.iFlags);
            IOUtilities.writePadding(aOut, 2);
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }

    public boolean isArray() {
        return false;
    }

    public boolean isInterface() {
        return this.iCF.isInterface();
    }

    public boolean hasStaticInitializer() {
        Method[] methods = this.iCF.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("<clinit>")) continue;
            return true;
        }
        return false;
    }

    public boolean hasMethod(Signature aSignature, boolean aStatic) {
        MethodRecord pRec = (MethodRecord)this.iMethods.get(aSignature);
        if (pRec == null) {
            return false;
        }
        return (pRec.getFlags() & 4) == 0 ^ aStatic;
    }

    public void initFlags() {
        this.iFlags = 0;
        if (this.isArray()) {
            this.iFlags |= 2;
        }
        if (this.isInterface()) {
            this.iFlags |= 8;
        }
        if (this.hasStaticInitializer()) {
            this.iFlags |= 4;
        }
    }

    public int getAllocationSize() throws TinyVMException {
        return (this.getClassSize() + 5) / 2;
    }

    public int getClassSize() throws TinyVMException {
        if (this.iClassSize != -1) {
            return this.iClassSize;
        }
        this.iClassSize = this.computeClassSize();
        return this.iClassSize;
    }

    public int computeClassSize() throws TinyVMException {
        int pSize = this.hasParent() ? this.getParent().getClassSize() : 0;
        Iterator iter = this.iInstanceFields.iterator();
        while (iter.hasNext()) {
            InstanceFieldRecord pRec = (InstanceFieldRecord)iter.next();
            pSize += pRec.getFieldSize();
        }
        return pSize;
    }

    public boolean hasParent() {
        return !"java.lang.Object".equals(this.iCF.getClassName());
    }

    public ClassRecord getParent() {
        if (!$assertionsDisabled && !this.hasParent()) {
            throw new AssertionError((Object)"Precondition: hasParent()");
        }
        ClassRecord result = this.iBinary.getClassRecord(this.iCF.getSuperclassName().replace('.', '/'));
        if (!$assertionsDisabled && result == null) {
            throw new AssertionError((Object)"Postconditon: result != null");
        }
        return result;
    }

    public void initParent() throws TinyVMException {
        if (this.hasParent()) {
            this.iParentClassIndex = this.iBinary.getClassIndex(this.getParent());
            if (this.iParentClassIndex == -1) {
                throw new TinyVMException("Superclass of " + this.iCF.getClassName() + " not found");
            }
        } else {
            this.iParentClassIndex = 0;
            if (!this.iCF.getClassName().equals("java.lang.Object")) {
                throw new TinyVMException("Expected java.lang.Object: " + this.iCF.getClassName());
            }
        }
    }

    public void storeReferredClasses(Hashtable aClasses, RecordTable aClassRecords, ClassPath aClassPath, Vector aInterfaceMethods) throws TinyVMException {
        ConstantPool pPool = this.iCF.getConstantPool();
        Constant[] constants = pPool.getConstantPool();
        for (int i = 0; i < constants.length; ++i) {
            Constant pEntry = constants[i];
            if (pEntry instanceof ConstantClass) {
                String pClassName = ((ConstantClass)pEntry).getBytes(pPool);
                if (pClassName.startsWith("[") || aClasses.get(pClassName) != null) continue;
                ClassRecord pRec = ClassRecord.getClassRecord(pClassName, aClassPath, this.iBinary);
                aClasses.put(pClassName, pRec);
                aClassRecords.add(pRec);
                continue;
            }
            if (pEntry instanceof ConstantMethodref) {
                String className = ((ConstantMethodref)pEntry).getClass(pPool).replace('.', '/');
                ClassRecord pClassRec = (ClassRecord)aClasses.get(className);
                if (pClassRec == null) {
                    pClassRec = ClassRecord.getClassRecord(className, aClassPath, this.iBinary);
                    aClasses.put(className, pClassRec);
                    aClassRecords.add(pClassRec);
                }
                ConstantNameAndType cnat = (ConstantNameAndType)this.iCF.getConstantPool().getConstant(((ConstantMethodref)pEntry).getNameAndTypeIndex());
                pClassRec.addUsedMethod(cnat.getName(this.iCF.getConstantPool()) + ":" + cnat.getSignature(this.iCF.getConstantPool()));
                continue;
            }
            if (pEntry instanceof ConstantInterfaceMethodref) {
                ConstantNameAndType cnat = (ConstantNameAndType)this.iCF.getConstantPool().getConstant(((ConstantInterfaceMethodref)pEntry).getNameAndTypeIndex());
                aInterfaceMethods.addElement(cnat.getName(this.iCF.getConstantPool()) + ":" + cnat.getSignature(this.iCF.getConstantPool()));
                continue;
            }
            if (!(pEntry instanceof ConstantNameAndType) || !((ConstantNameAndType)pEntry).getSignature(this.iCF.getConstantPool()).substring(0, 1).equals("(") || ((ConstantNameAndType)pEntry).getName(this.iCF.getConstantPool()).substring(0, 1).equals("<")) continue;
            aInterfaceMethods.addElement(((ConstantNameAndType)pEntry).getName(this.iCF.getConstantPool()) + ":" + ((ConstantNameAndType)pEntry).getSignature(this.iCF.getConstantPool()));
        }
    }

    public void addUsedMethod(String aRef) {
        this.iUsedMethods.addElement(aRef);
    }

    public static String cpEntryId(Constant aEntry) {
        String pClassName = aEntry.getClass().getName();
        int pDotIdx = pClassName.lastIndexOf(46);
        return pDotIdx == -1 ? pClassName : pClassName.substring(pDotIdx + 1);
    }

    MethodRecord getMethodRecord(Signature aSig) {
        return (MethodRecord)this.iMethods.get(aSig);
    }

    MethodRecord getVirtualMethodRecord(Signature aSig) {
        MethodRecord pRec = this.getMethodRecord(aSig);
        if (pRec != null) {
            return pRec;
        }
        if (!this.hasParent()) {
            return null;
        }
        return this.getParent().getVirtualMethodRecord(aSig);
    }

    int getMethodIndex(MethodRecord aRecord) {
        return this.iMethodTable.indexOf(aRecord);
    }

    int getApparentInstanceFieldOffset(String aName) throws TinyVMException {
        int pOffset = this.hasParent() ? this.getParent().getClassSize() : 0;
        Iterator iter = this.iInstanceFields.iterator();
        while (iter.hasNext()) {
            InstanceFieldRecord pRec = (InstanceFieldRecord)iter.next();
            if (pRec.getName().equals(aName)) {
                return pOffset;
            }
            pOffset += pRec.getFieldSize();
        }
        return -1;
    }

    public int getInstanceFieldOffset(String aName) throws TinyVMException {
        return this.getApparentInstanceFieldOffset(aName) + 4;
    }

    public int getStaticFieldOffset(String aName) throws TinyVMException {
        StaticValue pValue = (StaticValue)this.iStaticValues.get(aName);
        if (pValue == null) {
            return -1;
        }
        return pValue.getOffset() - this.iBinary.iStaticState.getOffset();
    }

    public int getStaticFieldIndex(String aName) {
        StaticFieldRecord pRecord = (StaticFieldRecord)this.iStaticFields.get(aName);
        if (pRecord == null) {
            return -1;
        }
        return this.iBinary.iStaticFields.indexOf(pRecord);
    }

    public void storeConstants(RecordTable aConstantTable, RecordTable aConstantValues) throws TinyVMException {
        ConstantPool pPool = this.iCF.getConstantPool();
        Constant[] constants = pPool.getConstantPool();
        for (int i = 0; i < constants.length; ++i) {
            ConstantRecord pRec;
            Constant pEntry = constants[i];
            if (!(pEntry instanceof ConstantString) && !(pEntry instanceof ConstantDouble) && !(pEntry instanceof ConstantFloat) && !(pEntry instanceof ConstantInteger) && !(pEntry instanceof ConstantLong) || aConstantTable.indexOf(pRec = new ConstantRecord(pPool, pEntry)) != -1) continue;
            aConstantTable.add(pRec);
            aConstantValues.add(pRec.constantValue());
        }
    }

    public void storeMethods(RecordTable aMethodTables, RecordTable aExceptionTables, HashVector aSignatures, boolean aAll) throws TinyVMException {
        Method[] methods = this.iCF.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method pMethod = methods[i];
            Signature pSignature = new Signature(pMethod.getName(), pMethod.getSignature());
            String meth = pMethod.getName() + ":" + pMethod.getSignature();
            if (!aAll && !this.iUseAllMethods && this.iUsedMethods.indexOf(meth) < 0 && !pMethod.getName().substring(0, 1).equals("<") && !meth.equals("run:()V")) continue;
            MethodRecord pMethodRecord = new MethodRecord(pMethod, pSignature, this, this.iBinary, aExceptionTables, aSignatures);
            this.iMethodTable.add(pMethodRecord);
            this.iMethods.put(pSignature, pMethodRecord);
        }
        aMethodTables.add(this.iMethodTable);
    }

    public void storeFields(RecordTable aInstanceFieldTables, RecordTable aStaticFields, RecordTable aStaticState) throws TinyVMException {
        Field[] fields = this.iCF.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field pField = fields[i];
            if (pField.isStatic()) {
                StaticValue pValue = new StaticValue(pField);
                StaticFieldRecord pRec = new StaticFieldRecord(pField, this);
                String pName = pField.getName().toString();
                if (!$assertionsDisabled && this.iStaticValues.containsKey(pName)) {
                    throw new AssertionError((Object)"Check: value not static");
                }
                this.iStaticValues.put(pName, pValue);
                this.iStaticFields.put(pName, pRec);
                aStaticState.add(pValue);
                aStaticFields.add(pRec);
                continue;
            }
            this.iInstanceFields.add(new InstanceFieldRecord(pField));
        }
        aInstanceFieldTables.add(this.iInstanceFields);
    }

    public void storeCode(RecordTable aCodeSequences, boolean aPostProcess) throws TinyVMException {
        Iterator iter = this.iMethodTable.iterator();
        while (iter.hasNext()) {
            MethodRecord pRec = (MethodRecord)iter.next();
            if (aPostProcess) {
                pRec.postProcessCode(aCodeSequences, this.iCF, this.iBinary);
                continue;
            }
            pRec.copyCode(aCodeSequences, this.iCF, this.iBinary);
        }
    }

    public static ClassRecord getClassRecord(String className, ClassPath aCP, Binary aBinary) throws TinyVMException {
        InputStream pIn;
        if (!$assertionsDisabled && className == null) {
            throw new AssertionError((Object)"Precondition: aName != null");
        }
        if (!$assertionsDisabled && aCP == null) {
            throw new AssertionError((Object)"Precondition: aCP != null");
        }
        if (!$assertionsDisabled && aBinary == null) {
            throw new AssertionError((Object)"Precondition: aBinary != null");
        }
        if (!$assertionsDisabled && className.indexOf(46) != -1) {
            throw new AssertionError((Object)("Precondition: className is in correct form: " + className));
        }
        try {
            pIn = aCP.getInputStream(className);
            if (!$assertionsDisabled && pIn == null) {
                throw new AssertionError((Object)"Check: pIn != null");
            }
        }
        catch (IOException e) {
            throw new TinyVMException("Class " + className.replace('/', '.') + " (file " + className + ".class) not found in CLASSPATH " + aCP);
        }
        ClassRecord pCR = new ClassRecord();
        try {
            pCR.iBinary = aBinary;
            pCR.iName = className;
            BufferedInputStream pBufIn = new BufferedInputStream(pIn, 4096);
            pCR.iCF = new ClassParser((InputStream)pBufIn, className).parse();
            ((InputStream)pBufIn).close();
        }
        catch (Exception e) {
            throw new TinyVMException(e.getMessage(), e);
        }
        return pCR;
    }

    public String toString() {
        return this.iName;
    }

    public int hashCode() {
        return this.iName.hashCode();
    }

    public boolean equals(Object aObj) {
        if (!(aObj instanceof ClassRecord)) {
            return false;
        }
        ClassRecord pOther = (ClassRecord)aObj;
        return pOther.iName.equals(this.iName);
    }

    static {
        $assertionsDisabled = !ClassRecord.class.desiredAssertionStatus();
    }
}

