/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import js.tinyvm.Binary;
import js.tinyvm.ClassRecord;
import js.tinyvm.ConstantRecord;
import js.tinyvm.MethodRecord;
import js.tinyvm.OpCodeConstants;
import js.tinyvm.OpCodeInfo;
import js.tinyvm.Signature;
import js.tinyvm.TinyVMException;
import js.tinyvm.TinyVMType;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Utility;

public class CodeUtilities
implements OpCodeConstants,
OpCodeInfo {
    String iFullName;
    JavaClass iCF;
    Binary iBinary;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CodeUtilities(String aMethodName, JavaClass aCF, Binary aBinary) {
        this.iFullName = CodeUtilities.fullMethod(aCF, aMethodName);
        this.iCF = aCF;
        this.iBinary = aBinary;
    }

    public void exitOnBadOpCode(int aOpCode) throws TinyVMException {
        throw new TinyVMException("Unsupported " + OPCODE_NAME[aOpCode] + " in " + this.iFullName + ".\n" + "The following features/conditions are currently unsupported:\n" + "- Switch statements.\n" + "- Integer increment constant too large. (If > 255, declare it).\n" + "- Arithmetic or logical operations on variables of type long.\n" + "- Remainder operations on floats or doubles.\n" + "- Too many constants or locals ( > 255).\n" + "- Method code too long ( > 64 Kb!).\n" + "");
    }

    public static String fullMethod(JavaClass aCF, String aMethodName) {
        return aCF.getClassName() + ":" + aMethodName;
    }

    public int processConstantIndex(int aPoolIndex) throws TinyVMException {
        Constant pEntry = this.iCF.getConstantPool().getConstant(aPoolIndex);
        if (!(pEntry instanceof ConstantInteger || pEntry instanceof ConstantFloat || pEntry instanceof ConstantString || pEntry instanceof ConstantDouble || pEntry instanceof ConstantLong)) {
            throw new TinyVMException("Classfile error: LDC-type instruction does not refer to a suitable constant. ");
        }
        ConstantRecord pRecord = new ConstantRecord(this.iCF.getConstantPool(), pEntry);
        int pIdx = this.iBinary.getConstantIndex(pRecord);
        if (pIdx == -1) {
            throw new TinyVMException("Bug CU-2: Didn't find constant " + pEntry + " of class " + this.iCF.getClassName());
        }
        return pIdx;
    }

    public int processClassIndex(int aPoolIndex) throws TinyVMException {
        Constant pEntry = this.iCF.getConstantPool().getConstant(aPoolIndex);
        if (!(pEntry instanceof ConstantClass)) {
            throw new TinyVMException("Classfile error: Instruction requiring CONSTANT_Class entry got " + (pEntry == null ? "null" : pEntry.getClass().getName()));
        }
        ConstantClass pClassEntry = (ConstantClass)pEntry;
        String pClassName = pClassEntry.getBytes(this.iCF.getConstantPool());
        if (pClassName.startsWith("[")) {
            throw new TinyVMException("In " + this.iFullName + ": Operations instanceof or " + "checkcast on array classes (" + pClassName + " in this case) are not yet supported by TinyVM.");
        }
        int pIdx = this.iBinary.getClassIndex(pClassName);
        if (pIdx == -1) {
            throw new TinyVMException("Bug CU-3: Didn't find class " + pEntry + " from class " + this.iCF.getClassName());
        }
        return pIdx;
    }

    public int processMultiArray(int aPoolIndex) throws TinyVMException {
        Constant pEntry = this.iCF.getConstantPool().getConstant(aPoolIndex);
        if (!(pEntry instanceof ConstantClass)) {
            throw new TinyVMException("Classfile error: Instruction requiring CONSTANT_Class entry got " + (pEntry == null ? "null" : pEntry.getClass().getName()));
        }
        ConstantClass pClassEntry = (ConstantClass)pEntry;
        int[] pTypeDim = CodeUtilities.getTypeAndDimensions(pClassEntry.getBytes(this.iCF.getConstantPool()));
        if (!$assertionsDisabled && pTypeDim[0] > 255) {
            throw new AssertionError((Object)"Check: correct type");
        }
        if (!($assertionsDisabled || pTypeDim[1] > 0 && pTypeDim[1] <= 255)) {
            throw new AssertionError((Object)"Check: correct dimension");
        }
        return pTypeDim[0] << 8 | pTypeDim[1];
    }

    public static int[] getTypeAndDimensions(String aMultiArrayDesc) {
        int i = 0;
        while (aMultiArrayDesc.charAt(i) == '[') {
            ++i;
        }
        return new int[]{Utility.typeOfSignature((String)aMultiArrayDesc.substring(i)), i};
    }

    int processField(int aFieldIndex, boolean aStatic) throws TinyVMException {
        Constant pEntry = this.iCF.getConstantPool().getConstant(aFieldIndex);
        if (!(pEntry instanceof ConstantFieldref)) {
            throw new TinyVMException("Classfile error: Instruction requiring CONSTANT_Fieldref entry got " + (pEntry == null ? "null" : pEntry.getClass().getName()));
        }
        ConstantFieldref pFieldEntry = (ConstantFieldref)pEntry;
        String className = pFieldEntry.getClass(this.iCF.getConstantPool()).replace('.', '/');
        ClassRecord pClassRecord = this.iBinary.getClassRecord(className);
        if (pClassRecord == null) {
            throw new TinyVMException("Bug CU-3: Didn't find class " + className + " from class " + this.iCF.getClassName());
        }
        ConstantNameAndType cnat = (ConstantNameAndType)this.iCF.getConstantPool().getConstant(pFieldEntry.getNameAndTypeIndex());
        String pName = cnat.getName(this.iCF.getConstantPool());
        if (aStatic) {
            int pClassIndex = this.iBinary.getClassIndex(pClassRecord);
            if (!($assertionsDisabled || pClassIndex >= 0 && pClassIndex <= 255)) {
                throw new AssertionError((Object)"Check: class index in range");
            }
            int pFieldIndex = pClassRecord.getStaticFieldIndex(pName);
            if (!($assertionsDisabled || pFieldIndex >= 0 && pFieldIndex <= 255)) {
                throw new AssertionError((Object)"Check: field index in range");
            }
            return pClassIndex << 8 | pFieldIndex;
        }
        int pOffset = pClassRecord.getInstanceFieldOffset(pName);
        if (pOffset == -1) {
            throw new TinyVMException("Error: Didn't find field " + className + ":" + pName + " from class " + this.iCF.getClassName());
        }
        if (!$assertionsDisabled && pOffset > 4095) {
            throw new AssertionError((Object)"Check: field offset in range");
        }
        TinyVMType fieldType = TinyVMType.tinyVMTypeFromSignature(cnat.getSignature(this.iCF.getConstantPool()));
        return fieldType.type() << 12 | pOffset;
    }

    int processMethod(int aMethodIndex, boolean aSpecial) throws TinyVMException {
        Constant pEntry = this.iCF.getConstantPool().getConstant(aMethodIndex);
        if (!(pEntry instanceof ConstantCP)) {
            throw new TinyVMException("Classfile error: Instruction requiring CONSTANT_MethodRef or CONSTANT_InterfaceMethodRef got " + (pEntry == null ? "null" : pEntry.getClass().getName()));
        }
        ConstantCP pMethodEntry = (ConstantCP)pEntry;
        String className = pMethodEntry.getClass(this.iCF.getConstantPool()).replace('.', '/');
        ClassRecord pClassRecord = this.iBinary.getClassRecord(className);
        if (pClassRecord == null) {
            throw new TinyVMException("Bug CU-4: Didn't find class " + className + " from class " + this.iCF.getClassName());
        }
        ConstantNameAndType pNT = (ConstantNameAndType)this.iCF.getConstantPool().getConstant(pMethodEntry.getNameAndTypeIndex());
        Signature pSig = new Signature(pNT.getName(this.iCF.getConstantPool()), pNT.getSignature(this.iCF.getConstantPool()));
        MethodRecord pMethod = pClassRecord.getVirtualMethodRecord(pSig);
        if (pMethod == null) {
            throw new TinyVMException("Method " + pSig + " not found  in " + className);
        }
        ClassRecord pTopClass = pMethod.getClassRecord();
        if (aSpecial) {
            int pClassIndex = this.iBinary.getClassIndex(pTopClass);
            if (!($assertionsDisabled || pClassIndex != -1 && pClassIndex < 256)) {
                throw new AssertionError((Object)"Check: class index in range");
            }
            int pMethodIndex = pTopClass.getMethodIndex(pMethod);
            if (!($assertionsDisabled || pMethodIndex != -1 && pMethodIndex < 255)) {
                throw new AssertionError((Object)"Check: method index in range");
            }
            return pClassIndex << 8 | pMethodIndex & 0xFF;
        }
        int pNumParams = pMethod.getNumParameterWords() - 1;
        if (!$assertionsDisabled && pNumParams >= 16) {
            throw new AssertionError((Object)"Check: number of parameters not to high");
        }
        int pSignature = pMethod.getSignatureId();
        if (!$assertionsDisabled && pSignature >= 4096) {
            throw new AssertionError((Object)"Check: signature in range");
        }
        return pNumParams << 12 | pSignature;
    }

    public byte[] processCode(byte[] aCode) throws TinyVMException {
        byte[] pOutCode = new byte[aCode.length];
        int i = 0;
        block14: while (i < aCode.length) {
            pOutCode[i] = aCode[i];
            int pOpCode = pOutCode[i] & 0xFF;
            ++i;
            switch (pOpCode) {
                case 18: {
                    pOutCode[i] = (byte)this.processConstantIndex(aCode[i] & 0xFF);
                    ++i;
                    continue block14;
                }
                case 20: {
                    int pIdx1 = this.processConstantIndex((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF);
                    pOutCode[i++] = (byte)(pIdx1 >> 8);
                    pOutCode[i++] = (byte)(pIdx1 & 0xFF);
                    continue block14;
                }
                case 189: {
                    pOutCode[i - 1] = -68;
                    pOutCode[i++] = 0;
                    pOutCode[i++] = 0;
                    continue block14;
                }
                case 197: {
                    int pIdx2 = this.processMultiArray((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF);
                    pOutCode[i++] = (byte)(pIdx2 >> 8);
                    pOutCode[i++] = (byte)(pIdx2 & 0xFF);
                    pOutCode[i] = aCode[i];
                    ++i;
                    continue block14;
                }
                case 187: 
                case 192: 
                case 193: {
                    int pIdx3 = this.processClassIndex((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF);
                    if (!$assertionsDisabled && pIdx3 >= 256) {
                        throw new AssertionError((Object)"Check: class index in range");
                    }
                    pOutCode[i++] = (byte)(pIdx3 >> 8);
                    pOutCode[i++] = (byte)(pIdx3 & 0xFF);
                    continue block14;
                }
                case 178: 
                case 179: {
                    int pWord1 = this.processField((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, true);
                    pOutCode[i++] = (byte)(pWord1 >> 8);
                    pOutCode[i++] = (byte)(pWord1 & 0xFF);
                    continue block14;
                }
                case 180: 
                case 181: {
                    int pWord2 = this.processField((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, false);
                    pOutCode[i++] = (byte)(pWord2 >> 8);
                    pOutCode[i++] = (byte)(pWord2 & 0xFF);
                    continue block14;
                }
                case 185: {
                    pOutCode[i - 1] = -74;
                    int pWord3 = this.processMethod((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, false);
                    pOutCode[i++] = (byte)(pWord3 >> 8);
                    pOutCode[i++] = (byte)(pWord3 & 0xFF);
                    pOutCode[i++] = 0;
                    pOutCode[i++] = 0;
                    continue block14;
                }
                case 183: 
                case 184: {
                    int pWord4 = this.processMethod((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, true);
                    pOutCode[i++] = (byte)(pWord4 >> 8);
                    pOutCode[i++] = (byte)(pWord4 & 0xFF);
                    continue block14;
                }
                case 182: {
                    int pWord5 = this.processMethod((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, false);
                    pOutCode[i++] = (byte)(pWord5 >> 8);
                    pOutCode[i++] = (byte)(pWord5 & 0xFF);
                    continue block14;
                }
                case 19: 
                case 97: 
                case 101: 
                case 105: 
                case 109: 
                case 113: 
                case 114: 
                case 115: 
                case 117: 
                case 121: 
                case 123: 
                case 125: 
                case 127: 
                case 129: 
                case 131: 
                case 148: 
                case 170: 
                case 171: 
                case 196: 
                case 200: 
                case 201: {
                    this.exitOnBadOpCode(pOpCode);
                    continue block14;
                }
                case 202: {
                    throw new TinyVMException("Invalid opcode detected: " + pOpCode + " " + OPCODE_NAME[pOpCode]);
                }
            }
            int pArgs = OPCODE_ARGS[pOpCode];
            if (pArgs == -1) {
                throw new TinyVMException("Bug CU-1: Got " + pOpCode + " in " + this.iFullName + ".");
            }
            for (int ctr = 0; ctr < pArgs; ++ctr) {
                pOutCode[i + ctr] = aCode[i + ctr];
            }
            i += pArgs;
        }
        return pOutCode;
    }

    static {
        $assertionsDisabled = !CodeUtilities.class.desiredAssertionStatus();
    }
}

