/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import js.tinyvm.TinyVMException;
import js.tinyvm.WritableData;
import js.tinyvm.WritableDataWithOffset;
import js.tinyvm.io.IByteWriter;
import js.tinyvm.io.IOUtilities;

public class RecordTable
extends WritableDataWithOffset {
    private String _name;
    private boolean _duplicates;
    private boolean _align;
    private ArrayList _list;
    private int _length;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RecordTable(String name, boolean allowDuplicates, boolean align) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError((Object)"Precondition: name != null");
        }
        this._name = name;
        this._duplicates = allowDuplicates;
        this._align = align;
        this._list = new ArrayList();
        this._length = -1;
    }

    public void add(WritableData element) {
        if (!$assertionsDisabled && element == null) {
            throw new AssertionError((Object)"Precondition: element != null");
        }
        if (this._duplicates || !this._list.contains(element)) {
            this._list.add(element);
        }
    }

    public WritableData get(int index) {
        if (!($assertionsDisabled || index >= 0 && index < this.size())) {
            throw new AssertionError((Object)"Precondition: index >= 0 && index < size()");
        }
        WritableData result = (WritableData)this._list.get(index);
        if (!$assertionsDisabled && result == null) {
            throw new AssertionError((Object)"Postconditon: result != null");
        }
        return result;
    }

    public int indexOf(WritableData element) {
        if (!$assertionsDisabled && element == null) {
            throw new AssertionError((Object)"Precondition: element != null");
        }
        return this._list.indexOf(element);
    }

    public Iterator iterator() {
        Iterator result = this._list.iterator();
        if (!$assertionsDisabled && result == null) {
            throw new AssertionError((Object)"Postconditon: result != null");
        }
        return result;
    }

    public int size() {
        return this._list.size();
    }

    public void dump(IByteWriter writer) throws TinyVMException {
        if (!$assertionsDisabled && writer == null) {
            throw new AssertionError((Object)"Precondition: writer != null");
        }
        try {
            boolean pDoVerify = true;
            Iterator iter = this._list.iterator();
            while (iter.hasNext()) {
                WritableData pData = (WritableData)iter.next();
                int pLength = pData.getLength();
                int pPrevSize = writer.offset();
                pData.dump(writer);
                if (!pDoVerify || writer.offset() == pPrevSize + pLength) continue;
                if (pData instanceof RecordTable) {
                    // empty if block
                }
                throw new TinyVMException("Bug RT-1: Written=" + (writer.offset() - pPrevSize) + " Length=" + pLength + " Class=" + pData.getClass().getName());
            }
            if (this._align) {
                IOUtilities.writePadding(writer, 2);
            }
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }

    public int getLength() throws TinyVMException {
        if (this._length == -1) {
            this._length = 0;
            Iterator iter = this._list.iterator();
            while (iter.hasNext()) {
                this._length += ((WritableData)iter.next()).getLength();
            }
            if (this._align) {
                this._length = IOUtilities.adjustedSize(this._length, 2);
            }
        }
        return this._length;
    }

    public void initOffset(int startOffset) throws TinyVMException {
        super.initOffset(startOffset);
        Iterator iter = this._list.iterator();
        while (iter.hasNext()) {
            WritableData element = (WritableData)iter.next();
            if (element instanceof WritableDataWithOffset) {
                ((WritableDataWithOffset)element).initOffset(startOffset);
            }
            startOffset += element.getLength();
        }
    }

    static {
        $assertionsDisabled = !RecordTable.class.desiredAssertionStatus();
    }
}

