/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import js.common.AbstractTool;
import js.common.ToolProgressMonitor;
import js.tinyvm.Binary;
import js.tinyvm.ClassPath;
import js.tinyvm.TinyVMException;
import js.tinyvm.io.BEByteWriter;
import js.tinyvm.io.ByteWriter;
import js.tinyvm.io.LEByteWriter;

public class TinyVMTool
extends AbstractTool {
    private static final Logger _logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TinyVMTool(ToolProgressMonitor monitor) {
        super(monitor);
    }

    public void link(String classpath, String[] classes, boolean all, OutputStream stream, boolean bigEndian) throws TinyVMException {
        if (!$assertionsDisabled && classpath == null) {
            throw new AssertionError((Object)"Precondition: classpath != null");
        }
        if (!$assertionsDisabled && classes == null) {
            throw new AssertionError((Object)"Precondition: classes != null");
        }
        if (!$assertionsDisabled && stream == null) {
            throw new AssertionError((Object)"Precondition: stream != null");
        }
        Binary binary = this.link(classpath, classes, all);
        binary.log(this.getProgressMonitor());
        this.dump(binary, stream, bigEndian);
    }

    public Binary link(String classpath, String[] entryClassNames, boolean all) throws TinyVMException {
        if (!$assertionsDisabled && classpath == null) {
            throw new AssertionError((Object)"Precondition: classpath != null");
        }
        if (!$assertionsDisabled && entryClassNames == null) {
            throw new AssertionError((Object)"Precondition: entryClassNames != null");
        }
        if (entryClassNames.length >= 256) {
            throw new TinyVMException("Too many entry classes (max is 255!)");
        }
        ClassPath computedClasspath = new ClassPath(classpath);
        for (int i = 0; i < entryClassNames.length; ++i) {
            entryClassNames[i] = entryClassNames[i].replace('.', '/');
        }
        Binary result = Binary.createFromClosureOf(entryClassNames, computedClasspath, all);
        for (int i = 0; i < entryClassNames.length; ++i) {
            if (result.hasMain(entryClassNames[i])) continue;
            throw new TinyVMException("Class " + entryClassNames[i] + " doesn't have a static void main(String[]) method");
        }
        if (!$assertionsDisabled && result == null) {
            throw new AssertionError((Object)"Postconditon: result != null");
        }
        return result;
    }

    public void dump(Binary binary, OutputStream stream, boolean bigEndian) throws TinyVMException {
        if (!$assertionsDisabled && binary == null) {
            throw new AssertionError((Object)"Precondition: binary != null");
        }
        if (!$assertionsDisabled && stream == null) {
            throw new AssertionError((Object)"Precondition: stream != null");
        }
        try {
            BufferedOutputStream bufferedStream = new BufferedOutputStream(stream, 4096);
            ByteWriter byteWriter = bigEndian ? new BEByteWriter(bufferedStream) : new LEByteWriter(bufferedStream);
            binary.dump(byteWriter);
            ((OutputStream)bufferedStream).close();
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }

    static {
        $assertionsDisabled = !TinyVMTool.class.desiredAssertionStatus();
        _logger = Logger.getLogger("TinyVM");
        _logger.setLevel(Level.OFF);
    }
}

