/* 
 * PROJECT: NyARToolkitCPP
 * --------------------------------------------------------------------------------
 *
 * The NyARToolkitCS is C++ version NyARToolkit class library.
 * 
 * Copyright (C)2008 R.Iizuka
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this framework; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * For further information please contact.
 *	http://nyatla.jp/nyatoolkit/
 *	<airmail(at)ebony.plala.or.jp>
 * 
 */
#pragma once
#include "RleLabelFragmentInfoStack.h"
#include "LabelOverlapChecker.h"
#include "NyARLabeling_Rle.h"
#include "INyARSquareDetector.h"
#include "NyARVertexCounter.h"
#include "SquareContourDetector.h"
#include "NyARPca2d_MatrixPCA_O2.h"
#include "../utils/NyArray.h"
#include "nyarcore.h"
#include <cstring>
namespace NyARToolkitCPP
{
	class NyARSquareDetector_Rle : public INyARSquareDetector
	{
	private:
		int _width;
		int _height;
		NyARLabeling_Rle* _labeling;

		LabelOverlapChecker<RleLabelFragmentInfo>* _overlap_checker;
		SquareContourDetector* _sqconvertor;
		ContourPickup* _cpickup;
		RleLabelFragmentInfoStack* _stack;

	private:
		int _max_coord;
		int* _xcoord;
		int* _ycoord;
		/**
		* ői_squre_max̃}[J[oNX쐬B
		* 
		* @param i_param
		*/
	public:
		NyARSquareDetector_Rle(const NyARCameraDistortionFactor& i_dist_factor_ref,const TNyARIntSize& i_size);
		virtual ~NyARSquareDetector_Rle();
	public:
		void detectMarker(const NyARBinRaster& i_raster, NyARSquareStack& o_square_stack);
	};


}
