/* 
 * PROJECT: NyARToolkitCPP
 * --------------------------------------------------------------------------------
 *
 * The NyARToolkitCS is C++ version NyARToolkit class library.
 * 
 * Copyright (C)2008 R.Iizuka
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this framework; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * For further information please contact.
 *	http://nyatla.jp/nyatoolkit/
 *	<airmail(at)ebony.plala.or.jp>
 * 
 */
#pragma once
#include "math.h"
#include "string.h"

namespace NyARToolkitCPP
{
	/*	constant
		--萔
	*/
	const static double NyAR_PI=3.1415926535897932384626433832795;

	/*	basic type
		--{^
	*/
	typedef unsigned char NyAR_BYTE_t;

	typedef long long NyAR_INT64_t;



	/*	complex type
		--^
	*/
	typedef struct TNyARDoublePoint2d_t TNyARDoublePoint2d;
	typedef struct TNyARDoublePoint3d_t TNyARDoublePoint3d;
	typedef struct TNyARIntPoint2d_t TNyARIntPoint2d;
	typedef struct TNyARIntRect_t TNyARIntRect;
	typedef struct TNyARIntSize_t TNyARIntSize;


	struct TNyARIntPoint2d_t
	{
		int x;
		int y;
		inline void getValue(int (&o_value)[2])
		{
			o_value[0]=this->x;
			o_value[1]=this->y;
			return;
		}
	};


	struct TNyARDoublePoint2d_t{
		double x;
		double y;
		inline void setValue(const TNyARDoublePoint2d& i_src)
		{
			this->x=i_src.x;
			this->y=i_src.y;
			return;
		}
		inline void setValue(const TNyARIntPoint2d& i_src)
		{
			this->x=(double)i_src.x;
			this->y=(double)i_src.y;
			return;
		}
		inline double dist()
		{
			return sqrt(this->x*this->x+this->y+this->y);
		}
	};


	struct TNyARDoublePoint3d_t{
		double x;
		double y;
		double z;
		inline void setValue(const TNyARDoublePoint3d& i_in)
		{
			this->x=i_in.x;
			this->y=i_in.y;
			this->z=i_in.z;
			return;
		}
	};




/*
	typedef struct TNyARIntPoint_t TNyARIntPoint;

	struct TNyARIntPoint_t
	{
		int x;
		int y;
	};
*/

	struct TNyARIntRect_t
	{
		int l;
		int t;
		int w;
		int h;
	};

	struct TNyARIntSize_t
	{
		int h;
		int w;
		inline bool isEqualSize(const TNyARIntSize& a)const
		{
			if (a.w == this->w && a.h == this->h){
				return true;
			}
			return false;
		}
		inline bool isEqualSize(const TNyARIntSize* a)const
		{
			if (a->w == this->w && a->h == this->h){
				return true;
			}
			return false;
		}
		inline bool isEqualSize(int i_width, int i_height)const
		{
			if (i_width == this->w && i_height == this->h){
				return true;
			}
			return false;
		}
	};

	/*	̃p[^
	*/
	typedef struct TNyARLinear_t TNyARLinear;
	struct TNyARLinear_t
	{
		double rise;//y̑
		double run;//x̑
		double intercept;//ؕ
	};

	/*	configulation type
		--RtBO^
	*/
	enum TNyAREndian{
		TNyAREndian_LITTLE,
		TNyAREndian_BIG
	};
}
