/* 
 * PROJECT: NyARToolkitCPP
 * --------------------------------------------------------------------------------
 *
 * The NyARToolkitCS is C++ version NyARToolkit class library.
 * 
 * Copyright (C)2008 R.Iizuka
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this framework; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * For further information please contact.
 *	http://nyatla.jp/nyatoolkit/
 *	<airmail(at)ebony.plala.or.jp>
 * 
 */
#pragma once

#include "nyarcore.h"
#include "NyARDoubleMatrix22.h"
#include "NyARVertexCounter.h"
#include "NyAR_types.h"
#include "INyARPca2d.h"
#include "NyARCameraDistortionFactor.h"
#include "NyARSquare.h"
#include "NyARObserv2IdealMap.h"

namespace NyARToolkitCPP
{
	class SquareContourDetector:public NyARBaseClass
	{
	private:
		double* _xpos;
		double* _ypos;	
		int __detectMarker_mkvertex[5];
		INyARPca2d* _pca;
		NyARVertexCounter __getSquareVertex_wv1;
		NyARVertexCounter __getSquareVertex_wv2;
		NyARDoubleMatrix22 __getSquareLine_evec;	
		NyARObserv2IdealMap* _dist_factor;
	public:
		SquareContourDetector(const TNyARIntSize& i_size,const NyARCameraDistortionFactor& i_distfactor_ref);
		virtual ~SquareContourDetector();
		bool coordToSquare(const int* i_xcoord,const int* i_ycoord,int i_st_index,int i_coord_num,int i_label_area,NyARSquare& o_square);
	private:
		bool getSquareLine(const int* i_mkvertex,const int* i_xcoord,const int* i_ycoord, NyARSquare& o_square);
		bool getSquareVertex(const int* i_x_coord,const int* i_y_coord, int i_vertex1_index, int i_coord_num, int i_area, int* o_vertex);
	public:
		static int normalizeCoord(int* i_coord_x, int* i_coord_y,int i_coord_num);
	};
}

