/* 
* PROJECT: NyARToolkitCPP
* --------------------------------------------------------------------------------
*
* The NyARToolkitCS is C++ version NyARToolkit class library.
* 
* Copyright (C)2008 R.Iizuka
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this framework; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
* 
* For further information please contact.
*	http://nyatla.jp/nyatoolkit/
*	<airmail(at)ebony.plala.or.jp>
* 
*/
#include "NyARCustomSingleDetectMarker.h"
#include "TNyARMatchPattResult.h"
#include "nyarcore.h"

namespace NyARToolkitCPP
{
#define AR_SQUARE_MAX 100

	NyARCustomSingleDetectMarker::NyARCustomSingleDetectMarker()
	{
		//initInstancesĉB
		return;
	}
	NyARCustomSingleDetectMarker::~NyARCustomSingleDetectMarker()
	{
		NyAR_SAFE_DELETE(this->_square_list);
		NyAR_SAFE_DELETE(this->_bin_raster);
		NyAR_SAFE_DELETE(this->_match_patt);
		NyAR_SAFE_DELETE(this->_deviation_data);
		NyAR_SAFE_DELETE(this->_transmat);
		//ォ
		NyAR_SAFE_DELETE(this->_patt);
		NyAR_SAFE_DELETE(this->_square_detect);
		return;
	}
	void NyARCustomSingleDetectMarker::initInstance(
		INyARColorPatt* i_patt_inst,
		INyARSquareDetector* i_sqdetect_inst,
		INyARTransMat* i_transmat_inst,
		const INyARRasterFilter_RgbToBin* i_filter,
		const NyARParam* i_ref_param,
		const NyARCode* i_ref_code,
		double i_marker_width)
	{
		const TNyARIntSize& scr_size=i_ref_param->getScreenSize();		
		// ̓IuWFNg
		this->_square_detect=i_sqdetect_inst;
		this->_transmat=i_transmat_inst;
		this->_tobin_filter=i_filter;
		this->_marker_width = i_marker_width;
		this->_patt = i_patt_inst;
		this->_deviation_data=new NyARMatchPattDeviationColorData(i_ref_code->getWidth(),i_ref_code->getHeight());
		this->_match_patt = new NyARMatchPatt_Color_WITHOUT_PCA(i_ref_code);		
		this->_bin_raster=new NyARBinRaster(scr_size.w,scr_size.h);
		this->_square_list=new NyARSquareStack(AR_SQUARE_MAX);
		this->_is_continue = false;
		return;
	}


	bool NyARCustomSingleDetectMarker::detectMarkerLite(const INyARRgbRaster& i_raster)
	{
		//TCY`FbN
		if(!this->_bin_raster->getSize().isEqualSize(i_raster.getSize())){
			throw NyARException();
		}

		//X^QlC[Wɕϊ.
		this->_tobin_filter->doFilter(i_raster,*this->_bin_raster);


		this->_detected_square = NULL;
		NyARSquareStack& l_square_list = *this->_square_list;
		// XNGAR[hT
		this->_square_detect->detectMarker(*this->_bin_raster, l_square_list);


		int number_of_square = l_square_list.getLength();
		// R[h͌H
		if (number_of_square < 1) {
			return false;
		}

		bool result=false;
		TNyARMatchPattResult& mr=this->__detectMarkerLite_mr;
		int square_index = 0;
		int direction = NyARSquare::DIRECTION_UNKNOWN;
		double confidence = 0;
		for(int i=0;i<number_of_square;i++){
			// ]ɂȂp^[C[W؂o
			if (!this->_patt->pickFromRaster(i_raster, *l_square_list.getItem(i))){
				continue;
			}
			//擾p^[J[f[^ɕϊĕ]B
			this->_deviation_data->setRaster(*this->_patt);
			if(!this->_match_patt->evaluate(*this->_deviation_data,mr)){
				continue;
			}
			const double c2 = mr.confidence;
			if (confidence > c2) {
				continue;
			}
			// ƈv}[J[ۂ
			square_index = i;
			direction = mr.direction;
			confidence = c2;
			result=true;
		}

		// }[J[ۑ
		this->_detected_square = l_square_list.getItem(square_index);
		this->_detected_direction = direction;
		this->_detected_confidence = confidence;
		return result;
	}


	void NyARCustomSingleDetectMarker::getTransmationMatrix(NyARTransMatResult &o_result)const
	{
		// Ԉv}[J[̈ʒuƂ̕ӂvZ
		if (this->_is_continue) {
			this->_transmat->transMatContinue(*this->_detected_square,this->_detected_direction,this->_marker_width, o_result);
		} else {
			this->_transmat->transMat(*this->_detected_square,this->_detected_direction,this->_marker_width, o_result);
		}
		return;
	}
	/**
	* ʏ̃}[J_z֎擾܂B
	* @param o_point
	* 4vfȏ̔zw肵ĉB擪4vfɒlRs[܂B
	*/
	void NyARCustomSingleDetectMarker::getSquarePosition(TNyARIntPoint2d o_point[])const
	{
		for(int i=0;i<4;i++)
		{
			o_point[i]=this->_detected_square->imvertex[i];
		}
		return;
	}
	/**
	* ʏ̃}[J_zւ̃t@XԂ܂B
	* ԂꂽIuWFNg̓NXɏLĂ܂BNX̃o֐sƓeς܂B
	* OŃf[^XgbNꍇ́AgetSquarePositionŕĉB
	* @return
	*/
	const TNyARIntPoint2d& NyARCustomSingleDetectMarker::refSquarePosition()const
	{
		return *(this->_detected_square->imvertex);
	}


	/**
	* o}[J[̈vxԂ܂B
	* 
	* @return }[J[̈vxԂ܂B0`1܂ł̒lƂ܂B vxႢꍇɂ́AF̉\Ȃ܂B
	* @throws NyARException
	*/
	double NyARCustomSingleDetectMarker::getConfidence()const
	{
		return this->_detected_confidence;
	}

	/**
	* o}[J[̕ʂԂ܂B
	* 
	* @return 0,1,2,3̉ꂩԂ܂B
	*/
	int NyARCustomSingleDetectMarker::getDirection()const
	{
		return this->_detected_direction;
	}

	/**
	* getTransmationMatrix̌vZ[hݒ肵܂B lTRUEłB
	* 
	* @param i_is_continue
	* TRUEȂAtransMatCont݊̌vZ܂B FALSEȂAtransMat݊̌vZ܂B
	*/
	void NyARCustomSingleDetectMarker::setContinueMode(bool i_is_continue)
	{
		this->_is_continue = i_is_continue;
	}


}
