#include "NyARRgbPixelReader_RGB24.h"
#include "NyARException.h"


namespace NyARToolkitCPP
{
	NyARRgbPixelReader_RGB24::NyARRgbPixelReader_RGB24(const TNyARIntSize* i_size,const NyAR_BYTE_t* i_buf)
	{
		this->_ref_buf = i_buf;
		this->_size = i_size;
	}
	void NyARRgbPixelReader_RGB24::getPixel(int i_x, int i_y, int* o_rgb)const
	{
		const NyAR_BYTE_t* rgb= this->_ref_buf+i_x + i_y * this->_size->w*3;
		o_rgb[0] = *(rgb+0)&0xff;// R
		o_rgb[1] = *(rgb+1)&0xff;// G
		o_rgb[2] = *(rgb+2)&0xff;// B
		return;
	}

	void NyARRgbPixelReader_RGB24::getPixelSet(const int* i_x,const int* i_y, int i_num, int* o_rgb)const
	{
		const int width = this->_size->w;
		const NyAR_BYTE_t* ref_buf = this->_ref_buf;
		for (int i = i_num - 1; i >= 0; i--){
			const NyAR_BYTE_t* rgb=ref_buf+(i_x[i] + i_y[i] * width)*3;
			o_rgb[i * 3 + 0] =*(rgb+0)&0xff;// R
			o_rgb[i * 3 + 1] =*(rgb+1)&0xff;// G
			o_rgb[i * 3 + 2] =*(rgb+2)&0xff;// B
		}
		return;
	}
	void NyARRgbPixelReader_RGB24::setPixel(int i_x, int i_y, const int* i_rgb)
	{
		NyARException::notImplement();
	}
	void NyARRgbPixelReader_RGB24::setPixels(const int* i_x, const int* i_y, int i_num, const int* i_intrgb)
	{
		NyARException::notImplement();
	}
}

