/* 
 * PROJECT: NyARToolkitCPP
 * --------------------------------------------------------------------------------
 *
 * The NyARToolkitCS is C++ version NyARToolkit class library.
 * 
 * Copyright (C)2008 R.Iizuka
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this framework; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * For further information please contact.
 *	http://nyatla.jp/nyatoolkit/
 *	<airmail(at)ebony.plala.or.jp>
 * 
 */
#include "NyARSquareDetector_ARToolKit.h"
#include "NyARLabeling_ARToolKit.h"
#include "NyARLabelingImage.h"
#include "NyARObserv2IdealMap.h"
#include "INyARSquareDetector.h"
#include "NyARVertexCounter.h"
#include "INyARPca2d.h"
#include "NyARPca2d_MatrixPCA_O2.h"
#include "../utils/NyArray.h"
#include "nyarcore.h"
#include <cstring>
#include <cstdio>
namespace NyARToolkitCPP
{
#define AR_AREA_MAX 100000// #define AR_AREA_MAX 100000
#define AR_AREA_MIN 70// #define AR_AREA_MIN 70



#define VERTEX_FACTOR 1.0// õt@N^
#define AR_AREA_MAX 100000// #define AR_AREA_MAX 100000
#define AR_AREA_MIN 70// #define AR_AREA_MIN 70


	NyARSquareDetector_ARToolKit::NyARSquareDetector_ARToolKit(const NyARCameraDistortionFactor& i_dist_factor_ref,const TNyARIntSize& i_size)
	{
		this->_width = i_size.w;
		this->_height = i_size.h;

		this->_labeling = new NyARLabeling_ARToolKit();
		this->_sqconvertor=new SquareContourDetector(i_size,i_dist_factor_ref);
		this->_limage = new NyARLabelingImage(this->_width, this->_height);
		this->_overlap_checker = new LabelOverlapChecker<NyARLabelingLabel>(32);


		// ֊s̍ő咷͉ʂɉf肤ő̒`TCYB
		int number_of_coord = (this->_width + this->_height) * 2;
		// ֊sobt@͒_ϊ̂ŁA֊sobt@̂Q{B
		this->_max_coord = number_of_coord;
		this->_xcoord = new int[number_of_coord * 2];
		this->_ycoord = new int[number_of_coord * 2];
		return;
	}
	NyARSquareDetector_ARToolKit::~NyARSquareDetector_ARToolKit()
	{
		NyAR_SAFE_DELETE(this->_overlap_checker);
		NyAR_SAFE_DELETE(this->_labeling);
		NyAR_SAFE_DELETE(this->_limage);
		NyAR_SAFE_DELETE(this->_sqconvertor);
		NyAR_SAFE_DELETE(this->_xcoord);
		NyAR_SAFE_DELETE(this->_ycoord);
		return;
	}
	void NyARSquareDetector_ARToolKit::detectMarker(const NyARBinRaster& i_raster, NyARSquareStack& o_square_stack)
	{
		NyARLabelingImage& limage = *this->_limage;


		// }[J[z_Zbg
		o_square_stack.clear();

		// xO
		int label_num =this->_labeling->labeling(i_raster,limage);

		// x0Ȃ炱܂
		if (label_num < 1){
			return;
		}

		NyARLabelingLabelStack& stack = limage.getLabelStack();
		// x傫ɐ
		stack.sortByArea();

		const NyArray<NyARLabelingLabel*>& labels = stack.getArray();



		// fJxǂݔ΂
		int i;
		for (i = 0; i < label_num; i++) {
			// Ώۓ̃xTCYɂȂ܂Ŗ
			if (labels.item[i]->area <= AR_AREA_MAX) {
				break;
			}
		}

		const int xsize = this->_width;
		const int ysize = this->_height;
		int* xcoord = this->_xcoord;
		int* ycoord = this->_ycoord;
		const int coord_max = this->_max_coord;
		LabelOverlapChecker<NyARLabelingLabel>* overlap = this->_overlap_checker;

		//dȂ`FbJ̍ő吔ݒ
		overlap->setMaxLabels(label_num);

		for (; i < label_num; i++) {
			const NyARLabelingLabel& label_pt = *labels.item[i];
			const int label_area = label_pt.area;
			// ΏۃTCYȂI
			if (label_area < AR_AREA_MIN) {
				break;
			}
			// Nbv̈悪ʂ̘gɐڂĂΏO
			if (label_pt.clip_l == 1 || label_pt.clip_r == xsize - 2) {// if(wclip[i*4+0] == 1 || wclip[i*4+1] ==xsize-2){
				continue;
			}
			if (label_pt.clip_t == 1 || label_pt.clip_b == ysize - 2) {// if( wclip[i*4+2] == 1 || wclip[i*4+3] ==ysize-2){
				continue;
			}
			// Ɍoꂽ`Ƃ̏dȂmF
			if (!overlap->check(label_pt)) {
				// dȂĂ悤B
				continue;
			}

			// ֊s擾
			const int coord_num = _cpickup->getContour(limage,limage.getTopClipTangentX(label_pt),label_pt.clip_t, coord_max, xcoord, ycoord);
			if (coord_num == coord_max) {
				// ֊s傫B
				continue;
			}
			//_̃CfNX擾
			const int vertex1 = SquareContourDetector::normalizeCoord(xcoord, ycoord, coord_num);

			//悪֊s
			NyARSquare* square_ptr = o_square_stack.prePush();
			if(!this->_sqconvertor->coordToSquare(xcoord,ycoord,vertex1,coord_num,label_area,*square_ptr)){
				o_square_stack.pop();// _̎擾oȂ̂Ŕj
				continue;				
			}
			// oς̋`̑xdȂ`FbNɒǉB
			overlap->push(&label_pt);

		}	
		return;
	}
}
