/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.pickup;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.pickup.INyARColorPatt;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARRgbPixelReader;
import jp.nyatla.nyartoolkit.core.rasterreader.NyARPerspectiveRasterReader;
import jp.nyatla.nyartoolkit.core.rasterreader.NyARRgbPixelReader_INT1D_X8R8G8B8_32;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARColorPatt_Perspective_O2
implements INyARColorPatt {
    private NyARIntPoint2d _edge = new NyARIntPoint2d();
    protected int[] _patdata;
    protected int _sample_per_pixel;
    protected NyARIntSize _size;
    private NyARRgbPixelReader_INT1D_X8R8G8B8_32 _pixelreader;
    private static final int BUFFER_FORMAT = 262402;
    private NyARPerspectiveRasterReader _perspective_reader;

    private void initializeInstance(int i_width, int i_height, int i_point_per_pix, int i_input_raster_type) {
        assert (i_width > 2 && i_height > 2);
        this._sample_per_pixel = i_point_per_pix;
        this._size = new NyARIntSize(i_width, i_height);
        this._patdata = new int[i_height * i_width];
        this._pixelreader = new NyARRgbPixelReader_INT1D_X8R8G8B8_32(this._patdata, this._size);
        this._perspective_reader = new NyARPerspectiveRasterReader(i_input_raster_type);
    }

    public NyARColorPatt_Perspective_O2(int i_width, int i_height, int i_point_per_pix) {
        this.initializeInstance(i_width, i_height, i_point_per_pix, 1);
        this._edge.setValue(0, 0);
    }

    public NyARColorPatt_Perspective_O2(int i_width, int i_height, int i_point_per_pix, int i_edge_percentage, int i_input_raster_type) {
        this.initializeInstance(i_width, i_height, i_point_per_pix, i_input_raster_type);
        this._edge.setValue(i_edge_percentage, i_edge_percentage);
    }

    public void setEdgeSizeByPercent(int i_x_percent, int i_y_percent, int i_sample_per_pixel) {
        assert (i_x_percent >= 0);
        assert (i_y_percent >= 0);
        this._edge.setValue(i_x_percent, i_y_percent);
        this._sample_per_pixel = i_sample_per_pixel;
    }

    @Override
    public final int getWidth() {
        return this._size.w;
    }

    @Override
    public final int getHeight() {
        return this._size.h;
    }

    @Override
    public final NyARIntSize getSize() {
        return this._size;
    }

    @Override
    public final INyARRgbPixelReader getRgbPixelReader() {
        return this._pixelreader;
    }

    @Override
    public Object getBuffer() {
        return this._patdata;
    }

    @Override
    public boolean hasBuffer() {
        return this._patdata != null;
    }

    @Override
    public void wrapBuffer(Object i_ref_buf) throws NyARException {
        NyARException.notImplement();
    }

    @Override
    public final int getBufferType() {
        return 262402;
    }

    @Override
    public final boolean isEqualBufferType(int i_type_value) {
        return 262402 == i_type_value;
    }

    @Override
    public boolean pickFromRaster(INyARRgbRaster image, NyARIntPoint2d[] i_vertexs) throws NyARException {
        return this._perspective_reader.read4Point(image, i_vertexs, this._edge.x, this._edge.y, this._sample_per_pixel, (INyARRgbRaster)this);
    }
}

