/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterfilter;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.rasterfilter.NyARRasterFilter_CustomToneTable;

public class NyARRasterFilter_ToneTable
extends NyARRasterFilter_CustomToneTable {
    public NyARRasterFilter_ToneTable(int i_raster_type) throws NyARException {
        super(i_raster_type);
    }

    public void setLine(int i_x, int i_y, double i_a) {
        if (i_a == 0.0) {
            int i = 0;
            while (i <= i_x) {
                this.table[i] = 0;
                ++i;
            }
            i = 0;
            while (i < 256) {
                this.table[i] = 255;
                ++i;
            }
        } else {
            int b = i_y - (int)(i_a * (double)i_x);
            int i = 0;
            while (i < 256) {
                int v = (int)(i_a * (double)i) + b;
                this.table[i] = v < 0 ? 0 : (v > 255 ? 255 : v);
                ++i;
            }
        }
    }

    public void setLine(double i_a) {
        this.setLine(0, 0, i_a);
    }

    public void setSigmoid(int i_x, int i_y, double i_gain) {
        int i = 0;
        while (i < 256) {
            int v = 255 * (int)(1.0 / (1.0 + Math.exp(i_gain * (double)(i - i_x))) - 0.5) + i_y;
            this.table[i] = v < 0 ? 0 : (v > 255 ? 255 : v);
            ++i;
        }
    }

    public void setGamma(double i_gamma) {
        int i = 0;
        while (i < 256) {
            this.table[i] = (int)(Math.pow((double)i / 255.0, i_gamma) * 255.0);
            ++i;
        }
    }
}

