/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.transmat.rotmatrix;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.param.NyARPerspectiveProjectionMatrix;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARLinear;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;

public class NyARRotVector {
    public double v1;
    public double v2;
    public double v3;
    private NyARPerspectiveProjectionMatrix _projection_mat_ref;
    private NyARDoubleMatrix44 _inv_cpara = new NyARDoubleMatrix44();

    public NyARRotVector(NyARPerspectiveProjectionMatrix i_cmat) throws NyARException {
        this._inv_cpara.inverse(i_cmat);
        this._projection_mat_ref = i_cmat;
    }

    public void exteriorProductFromLinear(NyARLinear i_linear1, NyARLinear i_linear2) {
        NyARPerspectiveProjectionMatrix cmat = this._projection_mat_ref;
        double w1 = i_linear1.a * i_linear2.b - i_linear2.a * i_linear1.b;
        double w2 = i_linear1.b * i_linear2.c - i_linear2.b * i_linear1.c;
        double w3 = i_linear1.c * i_linear2.a - i_linear2.c * i_linear1.a;
        double m0 = w1 * (cmat.m01 * cmat.m12 - cmat.m02 * cmat.m11) + w2 * cmat.m11 - w3 * cmat.m01;
        double m1 = -w1 * cmat.m00 * cmat.m12 + w3 * cmat.m00;
        double m2 = w1 * cmat.m00 * cmat.m11;
        double w = Math.sqrt(m0 * m0 + m1 * m1 + m2 * m2);
        this.v1 = m0 / w;
        this.v2 = m1 / w;
        this.v3 = m2 / w;
    }

    public void checkVectorByVertex(NyARDoublePoint2d i_start_vertex, NyARDoublePoint2d i_end_vertex) throws NyARException {
        NyARDoubleMatrix44 inv_cpara = this._inv_cpara;
        double world0 = inv_cpara.m00 * i_start_vertex.x * 10.0 + inv_cpara.m01 * i_start_vertex.y * 10.0 + inv_cpara.m02 * 10.0;
        double world1 = inv_cpara.m10 * i_start_vertex.x * 10.0 + inv_cpara.m11 * i_start_vertex.y * 10.0 + inv_cpara.m12 * 10.0;
        double world2 = inv_cpara.m20 * i_start_vertex.x * 10.0 + inv_cpara.m21 * i_start_vertex.y * 10.0 + inv_cpara.m22 * 10.0;
        double world3 = world0 + this.v1;
        double world4 = world1 + this.v2;
        double world5 = world2 + this.v3;
        NyARPerspectiveProjectionMatrix cmat = this._projection_mat_ref;
        double h = cmat.m20 * world0 + cmat.m21 * world1 + cmat.m22 * world2;
        if (h == 0.0) {
            throw new NyARException();
        }
        double camera0 = (cmat.m00 * world0 + cmat.m01 * world1 + cmat.m02 * world2) / h;
        double camera1 = (cmat.m10 * world0 + cmat.m11 * world1 + cmat.m12 * world2) / h;
        h = cmat.m20 * world3 + cmat.m21 * world4 + cmat.m22 * world5;
        if (h == 0.0) {
            throw new NyARException();
        }
        double camera2 = (cmat.m00 * world3 + cmat.m01 * world4 + cmat.m02 * world5) / h;
        double camera3 = (cmat.m10 * world3 + cmat.m11 * world4 + cmat.m12 * world5) / h;
        double v = (i_end_vertex.x - i_start_vertex.x) * (camera2 - camera0) + (i_end_vertex.y - i_start_vertex.y) * (camera3 - camera1);
        if (v < 0.0) {
            this.v1 = -this.v1;
            this.v2 = -this.v2;
            this.v3 = -this.v3;
        }
    }

    public static final void checkRotation(NyARRotVector io_vec1, NyARRotVector io_vec2) throws NyARException {
        double e4;
        double e3;
        double e2;
        double e1;
        int f;
        double vec11 = io_vec1.v2;
        double vec22 = io_vec2.v3;
        double vec12 = io_vec1.v3;
        double vec21 = io_vec2.v2;
        double vec30 = vec11 * vec22 - vec12 * vec21;
        double vec20 = io_vec2.v1;
        double vec10 = io_vec1.v1;
        double vec31 = vec12 * vec20 - vec10 * vec22;
        double vec32 = vec10 * vec21 - vec11 * vec20;
        double w = Math.sqrt(vec30 * vec30 + vec31 * vec31 + vec32 * vec32);
        if (w == 0.0) {
            throw new NyARException();
        }
        vec30 /= w;
        vec31 /= w;
        vec32 /= w;
        double cb = vec10 * vec20 + vec11 * vec21 + vec12 * vec22;
        if (cb < 0.0) {
            cb = -cb;
        }
        double ca = (Math.sqrt(cb + 1.0) + Math.sqrt(1.0 - cb)) * 0.5;
        if (vec31 * vec10 - vec11 * vec30 != 0.0) {
            f = 0;
        } else if (vec32 * vec10 - vec12 * vec30 != 0.0) {
            w = vec11;
            vec11 = vec12;
            vec12 = w;
            w = vec31;
            vec31 = vec32;
            vec32 = w;
            f = 1;
        } else {
            w = vec10;
            vec10 = vec12;
            vec12 = w;
            w = vec30;
            vec30 = vec32;
            vec32 = w;
            f = 2;
        }
        if (vec31 * vec10 - vec11 * vec30 == 0.0) {
            throw new NyARException();
        }
        double k1 = (vec11 * vec32 - vec31 * vec12) / (vec31 * vec10 - vec11 * vec30);
        double k2 = vec31 * ca / (vec31 * vec10 - vec11 * vec30);
        double k3 = (vec10 * vec32 - vec30 * vec12) / (vec30 * vec11 - vec10 * vec31);
        double k4 = vec30 * ca / (vec30 * vec11 - vec10 * vec31);
        double b = k1 * k2 + k3 * k4;
        double a = k1 * k1 + k3 * k3 + 1.0;
        double c = k2 * k2 + k4 * k4 - 1.0;
        double d = b * b - a * c;
        if (d < 0.0) {
            throw new NyARException();
        }
        double r1 = (-b + Math.sqrt(d)) / a;
        double p1 = k1 * r1 + k2;
        double q1 = k3 * r1 + k4;
        double r2 = (-b - Math.sqrt(d)) / a;
        double p2 = k1 * r2 + k2;
        double q2 = k3 * r2 + k4;
        if (f == 1) {
            w = q1;
            q1 = r1;
            r1 = w;
            w = q2;
            q2 = r2;
            r2 = w;
            w = vec11;
            vec11 = vec12;
            vec12 = w;
            w = vec31;
            vec31 = vec32;
            vec32 = w;
            f = 0;
        }
        if (f == 2) {
            w = p1;
            p1 = r1;
            r1 = w;
            w = p2;
            p2 = r2;
            r2 = w;
            w = vec10;
            vec10 = vec12;
            vec12 = w;
            w = vec30;
            vec30 = vec32;
            vec32 = w;
            f = 0;
        }
        if (vec31 * vec20 - vec21 * vec30 != 0.0) {
            f = 0;
        } else if (vec32 * vec20 - vec22 * vec30 != 0.0) {
            w = vec21;
            vec21 = vec22;
            vec22 = w;
            w = vec31;
            vec31 = vec32;
            vec32 = w;
            f = 1;
        } else {
            w = vec20;
            vec20 = vec22;
            vec22 = w;
            w = vec30;
            vec30 = vec32;
            vec32 = w;
            f = 2;
        }
        if (vec31 * vec20 - vec21 * vec30 == 0.0) {
            throw new NyARException();
        }
        k1 = (vec21 * vec32 - vec31 * vec22) / (vec31 * vec20 - vec21 * vec30);
        k2 = vec31 * ca / (vec31 * vec20 - vec21 * vec30);
        k3 = (vec20 * vec32 - vec30 * vec22) / (vec30 * vec21 - vec20 * vec31);
        k4 = vec30 * ca / (vec30 * vec21 - vec20 * vec31);
        b = k1 * k2 + k3 * k4;
        a = k1 * k1 + k3 * k3 + 1.0;
        c = k2 * k2 + k4 * k4 - 1.0;
        d = b * b - a * c;
        if (d < 0.0) {
            throw new NyARException();
        }
        double r3 = (-b + Math.sqrt(d)) / a;
        double p3 = k1 * r3 + k2;
        double q3 = k3 * r3 + k4;
        double r4 = (-b - Math.sqrt(d)) / a;
        double p4 = k1 * r4 + k2;
        double q4 = k3 * r4 + k4;
        if (f == 1) {
            w = q3;
            q3 = r3;
            r3 = w;
            w = q4;
            q4 = r4;
            r4 = w;
            w = vec21;
            vec21 = vec22;
            vec22 = w;
            w = vec31;
            vec31 = vec32;
            vec32 = w;
            f = 0;
        }
        if (f == 2) {
            w = p3;
            p3 = r3;
            r3 = w;
            w = p4;
            p4 = r4;
            r4 = w;
            w = vec20;
            vec20 = vec22;
            vec22 = w;
            w = vec30;
            vec30 = vec32;
            vec32 = w;
            f = 0;
        }
        if ((e1 = p1 * p3 + q1 * q3 + r1 * r3) < 0.0) {
            e1 = -e1;
        }
        if ((e2 = p1 * p4 + q1 * q4 + r1 * r4) < 0.0) {
            e2 = -e2;
        }
        if ((e3 = p2 * p3 + q2 * q3 + r2 * r3) < 0.0) {
            e3 = -e3;
        }
        if ((e4 = p2 * p4 + q2 * q4 + r2 * r4) < 0.0) {
            e4 = -e4;
        }
        if (e1 < e2) {
            if (e1 < e3) {
                if (e1 < e4) {
                    io_vec1.v1 = p1;
                    io_vec1.v2 = q1;
                    io_vec1.v3 = r1;
                    io_vec2.v1 = p3;
                    io_vec2.v2 = q3;
                    io_vec2.v3 = r3;
                } else {
                    io_vec1.v1 = p2;
                    io_vec1.v2 = q2;
                    io_vec1.v3 = r2;
                    io_vec2.v1 = p4;
                    io_vec2.v2 = q4;
                    io_vec2.v3 = r4;
                }
            } else if (e3 < e4) {
                io_vec1.v1 = p2;
                io_vec1.v2 = q2;
                io_vec1.v3 = r2;
                io_vec2.v1 = p3;
                io_vec2.v2 = q3;
                io_vec2.v3 = r3;
            } else {
                io_vec1.v1 = p2;
                io_vec1.v2 = q2;
                io_vec1.v3 = r2;
                io_vec2.v1 = p4;
                io_vec2.v2 = q4;
                io_vec2.v3 = r4;
            }
        } else if (e2 < e3) {
            if (e2 < e4) {
                io_vec1.v1 = p1;
                io_vec1.v2 = q1;
                io_vec1.v3 = r1;
                io_vec2.v1 = p4;
                io_vec2.v2 = q4;
                io_vec2.v3 = r4;
            } else {
                io_vec1.v1 = p2;
                io_vec1.v2 = q2;
                io_vec1.v3 = r2;
                io_vec2.v1 = p4;
                io_vec2.v2 = q4;
                io_vec2.v3 = r4;
            }
        } else if (e3 < e4) {
            io_vec1.v1 = p2;
            io_vec1.v2 = q2;
            io_vec1.v3 = r2;
            io_vec2.v1 = p3;
            io_vec2.v2 = q3;
            io_vec2.v3 = r3;
        } else {
            io_vec1.v1 = p2;
            io_vec1.v2 = q2;
            io_vec1.v3 = r2;
            io_vec2.v1 = p4;
            io_vec2.v2 = q4;
            io_vec2.v3 = r4;
        }
    }
}

