/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARVec;

public class NyARMat {
    protected double[][] m;
    protected int clm;
    protected int row;
    private int[] wk_nos_matrixSelfInv = new int[50];
    private static final double PCA_EPS = 1.0E-6;
    private static final int PCA_MAX_ITER = 100;
    private static final double PCA_VZERO = 1.0E-16;
    private final NyARVec wk_PCA_QRM_ev = new NyARVec(1);
    private NyARMat wk_PCA_PCA_u = null;
    private NyARMat wk_work_matrixPCA = null;
    private final NyARVec wk_vecTridiagonalize_vec = new NyARVec(0);
    private final NyARVec wk_vecTridiagonalize_vec2 = new NyARVec(0);

    protected NyARMat() throws NyARException {
        throw new NyARException();
    }

    public NyARMat(int i_row, int i_clm) {
        this.m = new double[i_row][i_clm];
        this.clm = i_clm;
        this.row = i_row;
    }

    public void realloc(int i_row, int i_clm) {
        if (i_row > this.m.length || i_clm > this.m[0].length) {
            this.m = new double[i_row][i_clm];
        }
        this.clm = i_clm;
        this.row = i_row;
    }

    public int getClm() {
        return this.clm;
    }

    public int getRow() {
        return this.row;
    }

    public void zeroClear() {
        int i = this.row - 1;
        while (i >= 0) {
            int i2 = this.clm - 1;
            while (i2 >= 0) {
                this.m[i][i2] = 0.0;
                --i2;
            }
            --i;
        }
    }

    public void copyFrom(NyARMat i_copy_from) throws NyARException {
        if (this.row != i_copy_from.row || this.clm != i_copy_from.clm) {
            throw new NyARException();
        }
        int r = this.row - 1;
        while (r >= 0) {
            int c = this.clm - 1;
            while (c >= 0) {
                this.m[r][c] = i_copy_from.m[r][c];
                --c;
            }
            --r;
        }
    }

    public double[][] getArray() {
        return this.m;
    }

    public void matrixMul(NyARMat a, NyARMat b) throws NyARException {
        if (a.clm != b.row || this.row != a.row || this.clm != b.clm) {
            throw new NyARException();
        }
        double[][] am = a.m;
        double[][] bm = b.m;
        double[][] dm = this.m;
        int r = 0;
        while (r < this.row) {
            int c = 0;
            while (c < this.clm) {
                double w = 0.0;
                int i = 0;
                while (i < a.clm) {
                    w += am[r][i] * bm[i][c];
                    ++i;
                }
                dm[r][c] = w;
                ++c;
            }
            ++r;
        }
    }

    public boolean matrixSelfInv() throws NyARException {
        double[] ap_i;
        double work;
        int j;
        int i;
        double[][] ap = this.m;
        int dimen = this.row;
        int dimen_1 = dimen - 1;
        int[] nos = this.wk_nos_matrixSelfInv;
        switch (dimen) {
            case 0: {
                throw new NyARException();
            }
            case 1: {
                ap[0][0] = 1.0 / ap[0][0];
                return true;
            }
        }
        int n = 0;
        while (n < dimen) {
            nos[n] = n;
            ++n;
        }
        int ip = 0;
        n = 0;
        while (n < dimen) {
            double[] ap_n = ap[n];
            double p = 0.0;
            i = n;
            while (i < dimen) {
                double d;
                double pbuf = Math.abs(ap[i][0]);
                if (p < d) {
                    p = pbuf;
                    ip = i;
                }
                ++i;
            }
            if (p == 0.0) {
                return false;
            }
            int nwork = nos[ip];
            nos[ip] = nos[n];
            nos[n] = nwork;
            double[] ap_ip = ap[ip];
            j = 0;
            while (j < dimen) {
                work = ap_ip[j];
                ap_ip[j] = ap_n[j];
                ap_n[j] = work;
                ++j;
            }
            work = ap_n[0];
            j = 0;
            while (j < dimen_1) {
                ap_n[j] = ap_n[j + 1] / work;
                ++j;
            }
            ap_n[j] = 1.0 / work;
            i = 0;
            while (i < dimen) {
                if (i != n) {
                    ap_i = ap[i];
                    work = ap_i[0];
                    j = 0;
                    while (j < dimen_1) {
                        ap_i[j] = ap_i[j + 1] - work * ap_n[j];
                        ++j;
                    }
                    ap_i[j] = -work * ap_n[j];
                }
                ++i;
            }
            ++n;
        }
        n = 0;
        while (n < dimen) {
            j = n;
            while (j < dimen) {
                if (nos[j] == n) break;
                ++j;
            }
            nos[j] = nos[n];
            i = 0;
            while (i < dimen) {
                ap_i = ap[i];
                work = ap_i[j];
                ap_i[j] = ap_i[n];
                ap_i[n] = work;
                ++i;
            }
            ++n;
        }
        return true;
    }

    public static void matrixTrans(NyARMat dest, NyARMat source) throws NyARException {
        if (dest.row != source.clm || dest.clm != source.row) {
            throw new NyARException();
        }
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        int r = 0;
        while (r < dest.row) {
            int c = 0;
            while (c < dest.clm) {
                dest.m[r][c] = source.m[c][r];
                ++c;
            }
            ++r;
        }
    }

    public static void matrixUnit(NyARMat unit) throws NyARException {
        if (unit.row != unit.clm) {
            throw new NyARException();
        }
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        int r = 0;
        while (r < unit.getRow()) {
            int c = 0;
            while (c < unit.getClm()) {
                unit.m[r][c] = r == c ? 1.0 : 0.0;
                ++c;
            }
            ++r;
        }
    }

    public void matrixDup(NyARMat i_source) throws NyARException {
        this.realloc(i_source.row, i_source.clm);
        double[][] src_m = i_source.m;
        double[][] dest_m = this.m;
        int r = this.row - 1;
        while (r >= 0) {
            int c = this.clm - 1;
            while (c >= 0) {
                dest_m[r][c] = src_m[r][c];
                --c;
            }
            --r;
        }
    }

    public NyARMat matrixAllocDup() throws NyARException {
        NyARMat result = new NyARMat(this.row, this.clm);
        double[][] dest_m = result.m;
        double[][] src_m = this.m;
        int r = this.row - 1;
        while (r >= 0) {
            int c = this.clm - 1;
            while (c >= 0) {
                dest_m[r][c] = src_m[r][c];
                --c;
            }
            --r;
        }
        return result;
    }

    public static void matrixInv(NyARMat dest, NyARMat source) throws NyARException {
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        dest.matrixDup(source);
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        dest.matrixSelfInv();
    }

    public NyARMat matrixAllocInv() throws NyARException {
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        NyARMat result = this.matrixAllocDup();
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        result.matrixSelfInv();
        return result;
    }

    public static NyARMat matrixAllocUnit(int dim) throws NyARException {
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        NyARMat result = new NyARMat(dim, dim);
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        NyARMat.matrixUnit(result);
        return result;
    }

    public int matrixDisp() throws NyARException {
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        System.out.println(" === matrix (" + this.row + "," + this.clm + ") ===");
        int r = 0;
        while (r < this.row) {
            System.out.print(" |");
            int c = 0;
            while (c < this.clm) {
                System.out.print(" " + this.m[r][c]);
                ++c;
            }
            System.out.println(" |");
            ++r;
        }
        System.out.println(" ======================");
        return 0;
    }

    private void PCA_EX(NyARVec mean) throws NyARException {
        int lrow = this.row;
        int lclm = this.clm;
        double[][] lm = this.m;
        if (lrow <= 0 || lclm <= 0) {
            throw new NyARException();
        }
        if (mean.getClm() != lclm) {
            throw new NyARException();
        }
        double[] mean_array = mean.getArray();
        int i2 = 0;
        while (i2 < lclm) {
            double w = 0.0;
            int i = 0;
            while (i < lrow) {
                w += lm[i][i2];
                ++i;
            }
            mean_array[i2] = w / (double)lrow;
            ++i2;
        }
    }

    private static void PCA_CENTER(NyARMat inout, NyARVec mean) throws NyARException {
        int row = inout.getRow();
        int clm = inout.getClm();
        if (mean.getClm() != clm) {
            throw new NyARException();
        }
        double[][] im = inout.m;
        double[] v = mean.getArray();
        switch (clm) {
            case 1: {
                double w0 = v[0];
                int i = 0;
                while (i < row) {
                    double[] dArray = im[i];
                    dArray[0] = dArray[0] - w0;
                    ++i;
                }
                break;
            }
            case 2: {
                double w0 = v[0];
                double w1 = v[1];
                int i = 0;
                while (i < row) {
                    double[] im_i = im[i];
                    im_i[0] = im_i[0] - w0;
                    im_i[1] = im_i[1] - w1;
                    ++i;
                }
                break;
            }
            default: {
                int i = 0;
                while (i < row) {
                    double[] im_i = im[i];
                    int j = 0;
                    while (j < clm) {
                        int n = j;
                        im_i[n] = im_i[n] - v[j];
                        ++j;
                    }
                    ++i;
                }
                break block0;
            }
        }
    }

    private static void PCA_x_by_xt(NyARMat input, NyARMat output) throws NyARException {
        NyARException.trap("\u52d5\u4f5c\u672a\u30c1\u30a7\u30c3\u30af/\u914d\u5217\u5316\u672a\u30c1\u30a7\u30c3\u30af");
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        int row = input.row;
        int clm = input.clm;
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        if (output.row != row || output.clm != row) {
            throw new NyARException();
        }
        int i = 0;
        while (i < row) {
            int j = 0;
            while (j < row) {
                if (j < i) {
                    NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
                    output.m[i][j] = output.m[j][i];
                } else {
                    NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
                    double[] in1 = input.m[i];
                    double[] in2 = input.m[j];
                    output.m[i][j] = 0.0;
                    int k = 0;
                    while (k < clm) {
                        double[] dArray = output.m[i];
                        int n = j;
                        dArray[n] = dArray[n] + in1[k] * in2[k];
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private static void PCA_xt_by_x(NyARMat input, NyARMat i_output) throws NyARException {
        int row = input.row;
        int clm = input.clm;
        if (i_output.row != clm || i_output.clm != clm) {
            throw new NyARException();
        }
        double[][] out_m = i_output.m;
        int i = 0;
        while (i < clm) {
            int j = 0;
            while (j < clm) {
                if (j < i) {
                    out_m[i][j] = out_m[j][i];
                } else {
                    double w = 0.0;
                    int k = 0;
                    while (k < row) {
                        double[] in_ = input.m[k];
                        w += in_[i] * in_[j];
                        ++k;
                    }
                    out_m[i][j] = w;
                }
                ++j;
            }
            ++i;
        }
    }

    private void PCA_QRM(NyARVec dv) throws NyARException {
        double t;
        double[] dv_array = dv.getArray();
        int dim = this.row;
        if (dim != this.clm || dim < 2) {
            throw new NyARException();
        }
        if (dv.getClm() != dim) {
            throw new NyARException();
        }
        NyARVec ev = this.wk_PCA_QRM_ev;
        ev.realloc(dim);
        double[] ev_array = ev.getArray();
        if (ev == null) {
            throw new NyARException();
        }
        double[][] L_m = this.m;
        this.vecTridiagonalize(dv, ev, 1);
        ev_array[0] = 0.0;
        int h = dim - 1;
        while (h > 0) {
            int j = h;
            while (j > 0 && Math.abs(ev_array[j]) > 1.0E-6 * (Math.abs(dv_array[j - 1]) + Math.abs(dv_array[j]))) {
                --j;
            }
            if (j != h) {
                int iter = 0;
                while (++iter <= 100) {
                    double w = (dv_array[h - 1] - dv_array[h]) / 2.0;
                    t = ev_array[h] * ev_array[h];
                    double s = Math.sqrt(w * w + t);
                    if (w < 0.0) {
                        s = -s;
                    }
                    double x = dv_array[j] - dv_array[h] + t / (w + s);
                    double y = ev_array[j + 1];
                    int k = j;
                    while (k < h) {
                        double c;
                        if (Math.abs(x) >= Math.abs(y)) {
                            if (Math.abs(x) > 1.0E-16) {
                                t = -y / x;
                                c = 1.0 / Math.sqrt(t * t + 1.0);
                                s = t * c;
                            } else {
                                c = 1.0;
                                s = 0.0;
                            }
                        } else {
                            t = -x / y;
                            s = 1.0 / Math.sqrt(t * t + 1.0);
                            c = t * s;
                        }
                        w = dv_array[k] - dv_array[k + 1];
                        t = (w * s + 2.0 * c * ev_array[k + 1]) * s;
                        int n = k;
                        dv_array[n] = dv_array[n] - t;
                        int n2 = k + 1;
                        dv_array[n2] = dv_array[n2] + t;
                        if (k > j) {
                            NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u30d1\u30b9");
                            ev_array[k] = c * ev_array[k] - s * y;
                        }
                        int n3 = k + 1;
                        ev_array[n3] = ev_array[n3] + s * (c * w - 2.0 * s * ev_array[k + 1]);
                        int i = 0;
                        while (i < dim) {
                            x = L_m[k][i];
                            y = L_m[k + 1][i];
                            L_m[k][i] = c * x - s * y;
                            L_m[k + 1][i] = s * x + c * y;
                            ++i;
                        }
                        if (k < h - 1) {
                            NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u30d1\u30b9");
                            x = ev_array[k + 1];
                            y = -s * ev_array[k + 2];
                            int n4 = k + 2;
                            ev_array[n4] = ev_array[n4] * c;
                        }
                        ++k;
                    }
                    if (Math.abs(ev_array[h]) > 1.0E-6 * (Math.abs(dv_array[h - 1]) + Math.abs(dv_array[h]))) continue;
                }
            }
            --h;
        }
        int k = 0;
        while (k < dim - 1) {
            int h2 = k;
            t = dv_array[h2];
            int i = k + 1;
            while (i < dim) {
                if (dv_array[i] > t) {
                    h2 = i;
                    t = dv_array[h2];
                }
                ++i;
            }
            dv_array[h2] = dv_array[k];
            dv_array[k] = t;
            this.flipRow(h2, k);
            ++k;
        }
    }

    private void flipRow(int i_row_1, int i_row_2) {
        double[] r1 = this.m[i_row_1];
        double[] r2 = this.m[i_row_2];
        int i = this.clm - 1;
        while (i >= 0) {
            double w = r1[i];
            r1[i] = r2[i];
            r2[i] = w;
            --i;
        }
    }

    private static void PCA_EV_create(NyARMat input, NyARMat u, NyARMat output, NyARVec ev) throws NyARException {
        int j;
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        int row = input.row;
        int clm = input.clm;
        if (row <= 0 || clm <= 0) {
            throw new NyARException();
        }
        if (u.row != row || u.clm != row) {
            throw new NyARException();
        }
        if (output.row != row || output.clm != clm) {
            throw new NyARException();
        }
        if (ev.getClm() != row) {
            throw new NyARException();
        }
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        double[][] m = output.m;
        double[][] in_ = input.m;
        double[] ev_array = ev.getArray();
        int i = 0;
        while (i < row) {
            NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
            if (ev_array[i] < 1.0E-16) break;
            NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
            double work = 1.0 / Math.sqrt(Math.abs(ev_array[i]));
            j = 0;
            while (j < clm) {
                double sum = 0.0;
                double[] m1 = u.m[i];
                int k = 0;
                while (k < row) {
                    sum += m1[k] + in_[k][j];
                    ++k;
                }
                m1[j] = sum * work;
                ++j;
            }
            ++i;
        }
        while (i < row) {
            NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
            ev_array[i] = 0.0;
            j = 0;
            while (j < clm) {
                m[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
    }

    private void PCA_PCA(NyARMat o_output, NyARVec o_ev) throws NyARException {
        NyARMat u;
        int min;
        double[] ev_array = o_ev.getArray();
        int l_clm = this.clm;
        int l_row = this.row;
        int n = min = l_clm < l_row ? l_clm : l_row;
        if (l_row < 2 || l_clm < 2) {
            throw new NyARException();
        }
        if (o_output.clm != this.clm) {
            throw new NyARException();
        }
        if (o_output.row != min) {
            throw new NyARException();
        }
        if (o_ev.getClm() != min) {
            throw new NyARException();
        }
        if (this.wk_PCA_PCA_u == null) {
            this.wk_PCA_PCA_u = u = new NyARMat(min, min);
        } else {
            u = this.wk_PCA_PCA_u;
            u.realloc(min, min);
        }
        if (l_row < l_clm) {
            NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
            NyARMat.PCA_x_by_xt(this, u);
        } else {
            NyARMat.PCA_xt_by_x(this, u);
        }
        u.PCA_QRM(o_ev);
        if (l_row < l_clm) {
            NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
            NyARMat.PCA_EV_create(this, u, o_output, o_ev);
        } else {
            int j;
            double[][] m1 = u.m;
            double[][] m2 = o_output.m;
            int i = 0;
            while (i < min) {
                if (ev_array[i] < 1.0E-16) break;
                j = 0;
                while (j < min) {
                    m2[i][j] = m1[i][j];
                    ++j;
                }
                ++i;
            }
            while (i < min) {
                ev_array[i] = 0.0;
                j = 0;
                while (j < min) {
                    m2[i][j] = 0.0;
                    ++j;
                }
                ++i;
            }
        }
    }

    public void matrixPCA(NyARMat o_evec, NyARVec o_ev, NyARVec mean) throws NyARException {
        NyARMat work;
        int check;
        int l_row = this.row;
        int l_clm = this.clm;
        int n = check = l_row < l_clm ? l_row : l_clm;
        if (l_row < 2 || l_clm < 2) {
            throw new NyARException();
        }
        if (o_evec.clm != l_clm || o_evec.row != check) {
            throw new NyARException();
        }
        if (o_ev.getClm() != check) {
            throw new NyARException();
        }
        if (mean.getClm() != l_clm) {
            throw new NyARException();
        }
        if (this.wk_work_matrixPCA == null) {
            this.wk_work_matrixPCA = work = this.matrixAllocDup();
        } else {
            work = this.wk_work_matrixPCA;
            work.matrixDup(this);
        }
        double srow = Math.sqrt(l_row);
        work.PCA_EX(mean);
        NyARMat.PCA_CENTER(work, mean);
        int i = 0;
        while (i < l_row) {
            int j = 0;
            while (j < l_clm) {
                double[] dArray = work.m[i];
                int n2 = j++;
                dArray[n2] = dArray[n2] / srow;
            }
            ++i;
        }
        work.PCA_PCA(o_evec, o_ev);
        double sum = 0.0;
        double[] ev_array = o_ev.getArray();
        int ev_clm = o_ev.getClm();
        i = 0;
        while (i < ev_clm) {
            sum += ev_array[i];
            ++i;
        }
        i = 0;
        while (i < ev_clm) {
            int n3 = i++;
            ev_array[n3] = ev_array[n3] / sum;
        }
    }

    public static void arMatrixPCA2(NyARMat input, NyARMat evec, NyARVec ev) throws NyARException {
        int check;
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        int row = input.row;
        int clm = input.clm;
        int n = check = row < clm ? row : clm;
        if (row < 2 || clm < 2) {
            throw new NyARException();
        }
        if (evec.getClm() != input.clm || evec.row != check) {
            throw new NyARException();
        }
        if (ev.getClm() != check) {
            throw new NyARException();
        }
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        NyARMat work = input.matrixAllocDup();
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u30d1\u30b9");
        work.PCA_PCA(evec, ev);
        double sum = 0.0;
        double[] ev_array = ev.getArray();
        int i = 0;
        while (i < ev.getClm()) {
            NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u30d1\u30b9");
            sum += ev_array[i];
            ++i;
        }
        i = 0;
        while (i < ev.getClm()) {
            NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u30d1\u30b9");
            int n2 = i++;
            ev_array[n2] = ev_array[n2] / sum;
        }
    }

    public static NyARMat matrixAllocMul(NyARMat a, NyARMat b) throws NyARException {
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        NyARMat dest = new NyARMat(a.row, b.clm);
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
        dest.matrixMul(a, b);
        return dest;
    }

    private static double Det_mdet(double[][] ap, int dimen, int rowa) throws NyARException {
        NyARException.trap("\u52d5\u4f5c\u672a\u30c1\u30a7\u30c3\u30af/\u914d\u5217\u5316\u672a\u30c1\u30a7\u30c3\u30af");
        double det = 1.0;
        int is_ = 0;
        int k = 0;
        while (k < dimen - 1) {
            double work;
            int mmax = k;
            int i = k + 1;
            while (i < dimen) {
                if (Math.abs(ap[i][k]) > Math.abs(ap[mmax][k])) {
                    mmax = i;
                }
                ++i;
            }
            if (mmax != k) {
                int j = k;
                while (j < dimen) {
                    work = ap[k][j];
                    ap[k][j] = ap[mmax][j];
                    ap[mmax][j] = work;
                    ++j;
                }
                ++is_;
            }
            i = k + 1;
            while (i < dimen) {
                work = ap[i][k] / ap[k][k];
                int j = k + 1;
                while (j < dimen) {
                    double[] dArray = ap[i];
                    int n = j;
                    dArray[n] = dArray[n] - work * ap[k][j];
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        int i = 0;
        while (i < dimen) {
            det = ap[i][i];
            ++i;
        }
        i = 0;
        while (i < is_) {
            det *= -1.0;
            ++i;
        }
        return det;
    }

    public static double arMatrixDet(NyARMat m) throws NyARException {
        NyARException.trap("\u52d5\u4f5c\u672a\u30c1\u30a7\u30c3\u30af/\u914d\u5217\u5316\u672a\u30c1\u30a7\u30c3\u30af");
        if (m.row != m.clm) {
            return 0.0;
        }
        return NyARMat.Det_mdet(m.getArray(), m.row, m.clm);
    }

    private void vecTridiagonalize(NyARVec d, NyARVec e, int i_e_start) throws NyARException {
        double t;
        double[] a_vec_k;
        NyARVec vec = this.wk_vecTridiagonalize_vec;
        if (this.clm != this.row) {
            throw new NyARException();
        }
        if (this.clm != d.getClm()) {
            throw new NyARException();
        }
        if (this.clm != e.getClm()) {
            throw new NyARException();
        }
        int dim = this.getClm();
        double[] d_vec = d.getArray();
        double[] e_vec = e.getArray();
        int k = 0;
        while (k < dim - 2) {
            a_vec_k = this.m[k];
            vec.setNewArray(a_vec_k, this.clm);
            NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u30d1\u30b9");
            d_vec[k] = a_vec_k[k];
            NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u30d1\u30b9");
            e_vec[k + i_e_start] = vec.vecHousehold(k + 1);
            if (e_vec[k + i_e_start] != 0.0) {
                int j;
                int i = k + 1;
                while (i < dim) {
                    double s = 0.0;
                    j = k + 1;
                    while (j < i) {
                        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
                        s += this.m[j][i] * a_vec_k[j];
                        ++j;
                    }
                    j = i;
                    while (j < dim) {
                        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
                        s += this.m[i][j] * a_vec_k[j];
                        ++j;
                    }
                    NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
                    d_vec[i] = s;
                    ++i;
                }
                a_vec_k = this.m[k];
                vec.setNewArray(a_vec_k, this.clm);
                NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u30d1\u30b9");
                t = vec.vecInnerproduct(d, k + 1) / 2.0;
                i = dim - 1;
                while (i > k) {
                    NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u30d1\u30b9");
                    double p = a_vec_k[i];
                    int n = i;
                    d_vec[n] = d_vec[n] - t * p;
                    double q = d_vec[i];
                    j = i;
                    while (j < dim) {
                        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u30d1\u30b9");
                        double[] dArray = this.m[i];
                        int n2 = j;
                        dArray[n2] = dArray[n2] - p * (d_vec[j] + q * a_vec_k[j]);
                        ++j;
                    }
                    --i;
                }
            }
            ++k;
        }
        if (dim >= 2) {
            d_vec[dim - 2] = this.m[dim - 2][dim - 2];
            e_vec[dim - 2 + i_e_start] = this.m[dim - 2][dim - 1];
        }
        if (dim >= 1) {
            d_vec[dim - 1] = this.m[dim - 1][dim - 1];
        }
        NyARVec vec2 = this.wk_vecTridiagonalize_vec2;
        int k2 = dim - 1;
        while (k2 >= 0) {
            int i;
            a_vec_k = this.m[k2];
            vec.setNewArray(a_vec_k, this.clm);
            if (k2 < dim - 2) {
                i = k2 + 1;
                while (i < dim) {
                    vec2.setNewArray(this.m[i], this.clm);
                    t = vec.vecInnerproduct(vec2, k2 + 1);
                    int j = k2 + 1;
                    while (j < dim) {
                        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u30d1\u30b9");
                        double[] dArray = this.m[i];
                        int n = j;
                        dArray[n] = dArray[n] - t * a_vec_k[j];
                        ++j;
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < dim) {
                a_vec_k[i] = 0.0;
                ++i;
            }
            a_vec_k[k2] = 1.0;
            --k2;
        }
    }
}

