/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.pickup;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.pickup.IpickFromRaster_Impl;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARRgbPixelReader;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

class pickFromRaster_N
implements IpickFromRaster_Impl {
    protected int _resolution;
    protected NyARIntSize _size_ref;
    protected NyARIntPoint2d _lt_ref;
    private int[] _rgb_temp;
    private int[] _rgb_px;
    private int[] _rgb_py;
    private double[] _cp1cy_cp2;
    private double[] _cp4cy_cp5;
    private double[] _cp7cy_1;

    public pickFromRaster_N(NyARIntPoint2d i_lt, int i_resolution, NyARIntSize i_source_size) {
        this._lt_ref = i_lt;
        this._resolution = i_resolution;
        this._size_ref = i_source_size;
        this._rgb_temp = new int[i_resolution * i_resolution * 3];
        this._rgb_px = new int[i_resolution * i_resolution];
        this._rgb_py = new int[i_resolution * i_resolution];
        this._cp1cy_cp2 = new double[i_resolution];
        this._cp4cy_cp5 = new double[i_resolution];
        this._cp7cy_1 = new double[i_resolution];
    }

    public void pickFromRaster(double[] i_cpara, INyARRgbRaster image, int[] o_patt) throws NyARException {
        int resolution = this._resolution;
        int res_pix = resolution * resolution;
        int img_x = image.getWidth();
        int img_y = image.getHeight();
        int[] rgb_tmp = this._rgb_temp;
        int[] rgb_px = this._rgb_px;
        int[] rgb_py = this._rgb_py;
        double[] cp1cy_cp2 = this._cp1cy_cp2;
        double[] cp4cy_cp5 = this._cp4cy_cp5;
        double[] cp7cy_1 = this._cp7cy_1;
        double cp0 = i_cpara[0];
        double cp3 = i_cpara[3];
        double cp6 = i_cpara[6];
        double cp1 = i_cpara[1];
        double cp2 = i_cpara[2];
        double cp4 = i_cpara[4];
        double cp5 = i_cpara[5];
        double cp7 = i_cpara[7];
        int pick_y = this._lt_ref.y;
        int pick_x = this._lt_ref.x;
        INyARRgbPixelReader reader = image.getRgbPixelReader();
        int p = 0;
        int iy = 0;
        while (iy < this._size_ref.h * resolution) {
            int w = pick_y + iy;
            cp1cy_cp2[0] = cp1 * (double)w + cp2;
            cp4cy_cp5[0] = cp4 * (double)w + cp5;
            cp7cy_1[0] = cp7 * (double)w + 1.0;
            int i2y = 1;
            while (i2y < resolution) {
                cp1cy_cp2[i2y] = cp1cy_cp2[i2y - 1] + cp1;
                cp4cy_cp5[i2y] = cp4cy_cp5[i2y - 1] + cp4;
                cp7cy_1[i2y] = cp7cy_1[i2y - 1] + cp7;
                ++i2y;
            }
            int ix = 0;
            while (ix < this._size_ref.w * resolution) {
                int n = 0;
                w = pick_x + ix;
                i2y = resolution - 1;
                while (i2y >= 0) {
                    double cp0cx = cp0 * (double)w + cp1cy_cp2[i2y];
                    double cp6cx = cp6 * (double)w + cp7cy_1[i2y];
                    double cp3cx = cp3 * (double)w + cp4cy_cp5[i2y];
                    double m = 1.0 / cp6cx;
                    double d = -cp6 / (cp6cx * (cp6cx + cp6));
                    double m2 = cp0cx * m;
                    double m3 = cp3cx * m;
                    double d2 = cp0cx * d + cp0 * (m + d);
                    double d3 = cp3cx * d + cp3 * (m + d);
                    int i2x = resolution - 1;
                    while (i2x >= 0) {
                        int x = rgb_px[n] = (int)m2;
                        int y = rgb_py[n] = (int)m3;
                        if (x < 0 || x >= img_x || y < 0 || y >= img_y) {
                            if (x < 0) {
                                rgb_px[n] = 0;
                            } else if (x >= img_x) {
                                rgb_px[n] = img_x - 1;
                            }
                            if (y < 0) {
                                rgb_py[n] = 0;
                            } else if (y >= img_y) {
                                rgb_py[n] = img_y - 1;
                            }
                        }
                        ++n;
                        m2 += d2;
                        m3 += d3;
                        --i2x;
                    }
                    --i2y;
                }
                reader.getPixelSet(rgb_px, rgb_py, res_pix, rgb_tmp);
                int b = 0;
                int g = 0;
                int r = 0;
                int i = res_pix * 3 - 1;
                while (i > 0) {
                    b += rgb_tmp[i--];
                    g += rgb_tmp[i--];
                    r += rgb_tmp[i--];
                }
                o_patt[p] = ((r /= res_pix) & 0xFF) << 16 | ((g /= res_pix) & 0xFF) << 8 | (b /= res_pix) & 0xFF;
                ++p;
                ix += resolution;
            }
            iy += resolution;
        }
    }
}

