/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.markersystem;

import java.io.FileInputStream;
import java.io.InputStream;
import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.analyzer.histogram.INyARHistogramAnalyzer_Threshold;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.NyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterdriver.INyARPerspectiveCopy;
import jp.nyatla.nyartoolkit.core.transmat.INyARTransMat;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;
import jp.nyatla.nyartoolkit.markersystem.INyARMarkerSystemConfig;
import jp.nyatla.nyartoolkit.markersystem.INyARMarkerSystemSquareDetect;
import jp.nyatla.nyartoolkit.markersystem.NyARSensor;
import jp.nyatla.nyartoolkit.markersystem.NyARSingleCameraSystem;
import jp.nyatla.nyartoolkit.markersystem.OnSquareDetect;
import jp.nyatla.nyartoolkit.markersystem.SquareDetect;
import jp.nyatla.nyartoolkit.markersystem.utils.ARMarkerList;
import jp.nyatla.nyartoolkit.markersystem.utils.ARPlayCardList;
import jp.nyatla.nyartoolkit.markersystem.utils.NyIdList;
import jp.nyatla.nyartoolkit.markersystem.utils.TMarkerData;
import jp.nyatla.nyartoolkit.markersystem.utils.TrackingList;

public class NyARMarkerSystem
extends NyARSingleCameraSystem {
    public static final int THLESHOLD_AUTO = Integer.MAX_VALUE;
    public static final int LOST_DELAY_DEFAULT = 5;
    private static final int MASK_IDTYPE = 0x7FFFF000;
    private static final int MASK_IDNUM = 4095;
    private static final int IDTYPE_ARTK = 0;
    private static final int IDTYPE_NYID = 4096;
    private static final int IDTYPE_PSID = 8192;
    protected INyARMarkerSystemSquareDetect _sqdetect;
    private int _last_gs_th;
    private int _bin_threshold = Integer.MAX_VALUE;
    private TrackingList _tracking_list;
    private ARMarkerList _armk_list;
    private NyIdList _idmk_list;
    private ARPlayCardList _psmk_list;
    private int lost_th = 5;
    private INyARTransMat _transmat;
    private static final int INITIAL_MARKER_STACK_SIZE = 10;
    private NyARDoublePoint3d _wk_3dpos = new NyARDoublePoint3d();
    private NyARDoublePoint3d[] __pos3d = NyARDoublePoint3d.createArray(4);
    private NyARDoublePoint2d[] __pos2d = NyARDoublePoint2d.createArray(4);
    private long _time_stamp = -1L;
    protected INyARHistogramAnalyzer_Threshold _hist_th;
    private OnSquareDetect _on_sq_handler;

    public NyARMarkerSystem(INyARMarkerSystemConfig i_config) throws NyARException {
        super(i_config.getNyARParam());
        this.initInstance(i_config);
        this._armk_list = new ARMarkerList();
        this._idmk_list = new NyIdList();
        this._psmk_list = new ARPlayCardList();
        this._tracking_list = new TrackingList();
        this._transmat = i_config.createTransmatAlgorism();
        this._on_sq_handler = new OnSquareDetect(i_config, this._armk_list, this._idmk_list, this._psmk_list, this._tracking_list, 10);
    }

    protected void initInstance(INyARMarkerSystemConfig i_ref_config) throws NyARException {
        this._sqdetect = new SquareDetect(i_ref_config);
        this._hist_th = i_ref_config.createAutoThresholdArgorism();
    }

    public int addNyIdMarker(long i_id, double i_marker_size) throws NyARException {
        return this.addNyIdMarker(i_id, i_id, i_marker_size);
    }

    public int addNyIdMarker(long i_id_s, long i_id_e, double i_marker_size) throws NyARException {
        NyIdList.Item target = new NyIdList.Item(i_id_s, i_id_e, i_marker_size);
        if (!this._idmk_list.add(target)) {
            throw new NyARException();
        }
        this._tracking_list.add(target);
        this._on_sq_handler.setMaxDetectMarkerCapacity(this._tracking_list.size());
        return this._idmk_list.size() - 1 | 0x1000;
    }

    public int addPsARPlayCard(int i_id_s, int i_id_e, double i_marker_size) throws NyARException {
        assert (i_id_s > 0 && i_id_s <= 6);
        assert (i_id_e > 0 && i_id_e <= 6);
        ARPlayCardList.Item target = new ARPlayCardList.Item(i_id_s, i_id_e, i_marker_size);
        if (!this._psmk_list.add(target)) {
            throw new NyARException();
        }
        this._tracking_list.add(target);
        this._on_sq_handler.setMaxDetectMarkerCapacity(this._tracking_list.size());
        return this._psmk_list.size() - 1 | 0x2000;
    }

    public int addPsARPlayCard(int i_id, double i_marker_size) throws NyARException {
        return this.addPsARPlayCard(i_id, i_id, i_marker_size);
    }

    public int addARMarker(NyARCode i_code, int i_patt_edge_percentage, double i_marker_size) throws NyARException {
        ARMarkerList.Item target = new ARMarkerList.Item(i_code, i_patt_edge_percentage, i_marker_size);
        if (!this._armk_list.add(target)) {
            throw new NyARException();
        }
        this._tracking_list.add(target);
        this._on_sq_handler.setMaxDetectMarkerCapacity(this._tracking_list.size());
        return this._armk_list.size() - 1;
    }

    public int addARMarker(InputStream i_stream, int i_patt_resolution, int i_patt_edge_percentage, double i_marker_size) throws NyARException {
        NyARCode c = NyARCode.createFromARPattFile(i_stream, i_patt_resolution, i_patt_resolution);
        return this.addARMarker(c, i_patt_edge_percentage, i_marker_size);
    }

    public int addARMarker(String i_file_name, int i_patt_resolution, int i_patt_edge_percentage, double i_marker_size) throws NyARException {
        try {
            NyARCode c = NyARCode.createFromARPattFile(new FileInputStream(i_file_name), i_patt_resolution, i_patt_resolution);
            return this.addARMarker(c, i_patt_edge_percentage, i_marker_size);
        }
        catch (Exception e) {
            throw new NyARException(e);
        }
    }

    public int addARMarker(INyARRgbRaster i_raster, int i_patt_resolution, int i_patt_edge_percentage, double i_marker_size) throws NyARException {
        NyARCode c = new NyARCode(i_patt_resolution, i_patt_resolution);
        NyARIntSize s = i_raster.getSize();
        INyARPerspectiveCopy pc = (INyARPerspectiveCopy)i_raster.createInterface(INyARPerspectiveCopy.class);
        NyARRgbRaster tr = new NyARRgbRaster(i_patt_resolution, i_patt_resolution);
        pc.copyPatt(0.0, 0.0, s.w, 0.0, s.w, s.h, 0.0, s.h, i_patt_edge_percentage, i_patt_edge_percentage, 4, tr);
        c.setRaster(tr);
        return this.addARMarker(c, i_patt_edge_percentage, i_marker_size);
    }

    public boolean isExistMarker(int i_id) throws NyARException {
        return this.getLife(i_id) > 0L;
    }

    public double getConfidence(int i_id) throws NyARException {
        if ((i_id & 0x7FFFF000) == 0) {
            return ((ARMarkerList.Item)this._armk_list.get((int)(i_id & 0xFFF))).cf;
        }
        throw new NyARException();
    }

    public long getNyId(int i_id) throws NyARException {
        if ((i_id & 0x7FFFF000) == 4096) {
            return ((NyIdList.Item)this._idmk_list.get((int)(i_id & 0xFFF))).nyid;
        }
        throw new NyARException();
    }

    public int getCurrentThreshold() {
        return this._last_gs_th;
    }

    public long getLife(int i_id) throws NyARException {
        switch (i_id & 0x7FFFF000) {
            case 0: {
                return ((ARMarkerList.Item)this._armk_list.get((int)(i_id & 0xFFF))).life;
            }
            case 4096: {
                return ((NyIdList.Item)this._idmk_list.get((int)(i_id & 0xFFF))).life;
            }
            case 8192: {
                return ((ARPlayCardList.Item)this._psmk_list.get((int)(i_id & 0xFFF))).life;
            }
        }
        throw new NyARException();
    }

    public long getLostCount(int i_id) throws NyARException {
        switch (i_id & 0x7FFFF000) {
            case 0: {
                return ((ARMarkerList.Item)this._armk_list.get((int)(i_id & 0xFFF))).lost_count;
            }
            case 4096: {
                return ((NyIdList.Item)this._idmk_list.get((int)(i_id & 0xFFF))).lost_count;
            }
            case 8192: {
                return ((ARPlayCardList.Item)this._psmk_list.get((int)(i_id & 0xFFF))).lost_count;
            }
        }
        throw new NyARException();
    }

    public NyARDoublePoint3d getMarkerPlanePos(int i_id, int i_x, int i_y, NyARDoublePoint3d i_out) throws NyARException {
        this._frustum.unProjectOnMatrix(i_x, i_y, this.getMarkerMatrix(i_id), i_out);
        return i_out;
    }

    public NyARDoublePoint2d getScreenPos(int i_id, double i_x, double i_y, double i_z, NyARDoublePoint2d i_out) throws NyARException {
        NyARDoublePoint3d _wk_3dpos = this._wk_3dpos;
        this.getMarkerMatrix(i_id).transform3d(i_x, i_y, i_z, _wk_3dpos);
        this._frustum.project(_wk_3dpos, i_out);
        return i_out;
    }

    public INyARRgbRaster getMarkerPlaneImage(int i_id, NyARSensor i_sensor, double i_x1, double i_y1, double i_x2, double i_y2, double i_x3, double i_y3, double i_x4, double i_y4, INyARRgbRaster i_raster) throws NyARException {
        NyARDoublePoint3d[] pos = this.__pos3d;
        NyARDoublePoint2d[] pos2 = this.__pos2d;
        NyARDoubleMatrix44 tmat = this.getMarkerMatrix(i_id);
        tmat.transform3d(i_x1, i_y1, 0.0, pos[1]);
        tmat.transform3d(i_x2, i_y2, 0.0, pos[0]);
        tmat.transform3d(i_x3, i_y3, 0.0, pos[3]);
        tmat.transform3d(i_x4, i_y4, 0.0, pos[2]);
        int i = 3;
        while (i >= 0) {
            this._frustum.project(pos[i], pos2[i]);
            --i;
        }
        return i_sensor.getPerspectiveImage(pos2[0].x, pos2[0].y, pos2[1].x, pos2[1].y, pos2[2].x, pos2[2].y, pos2[3].x, pos2[3].y, i_raster);
    }

    public INyARRgbRaster getMarkerPlaneImage(int i_id, NyARSensor i_sensor, double i_l, double i_t, double i_w, double i_h, INyARRgbRaster i_raster) throws NyARException {
        return this.getMarkerPlaneImage(i_id, i_sensor, i_l + i_w - 1.0, i_t + i_h - 1.0, i_l, i_t + i_h - 1.0, i_l, i_t, i_l + i_w - 1.0, i_t, i_raster);
    }

    public NyARDoubleMatrix44 getMarkerMatrix(int i_id) throws NyARException {
        switch (i_id & 0x7FFFF000) {
            case 0: {
                return ((ARMarkerList.Item)this._armk_list.get((int)(i_id & 0xFFF))).tmat;
            }
            case 4096: {
                return ((NyIdList.Item)this._idmk_list.get((int)(i_id & 0xFFF))).tmat;
            }
            case 8192: {
                return ((ARPlayCardList.Item)this._psmk_list.get((int)(i_id & 0xFFF))).tmat;
            }
        }
        throw new NyARException();
    }

    public NyARIntPoint2d[] getMarkerVertex2D(int i_id) throws NyARException {
        switch (i_id & 0x7FFFF000) {
            case 0: {
                return ((ARMarkerList.Item)this._armk_list.get((int)(i_id & 0xFFF))).tl_vertex;
            }
            case 4096: {
                return ((NyIdList.Item)this._idmk_list.get((int)(i_id & 0xFFF))).tl_vertex;
            }
            case 8192: {
                return ((ARPlayCardList.Item)this._psmk_list.get((int)(i_id & 0xFFF))).tl_vertex;
            }
        }
        throw new NyARException();
    }

    public void setBinThreshold(int i_th) {
        this._bin_threshold = i_th;
    }

    public void setConfidenceThreshold(double i_val) {
        this._armk_list.setConficenceTh(i_val);
    }

    public void setLostDelay(int i_delay) {
        this.lost_th = i_delay;
    }

    public void update(NyARSensor i_sensor) throws NyARException {
        TMarkerData target;
        long time_stamp = i_sensor.getTimeStamp();
        if (this._time_stamp == time_stamp) {
            return;
        }
        int th = this._bin_threshold == Integer.MAX_VALUE ? this._hist_th.getThreshold(i_sensor.getGsHistogram()) : this._bin_threshold;
        this._tracking_list.prepare();
        this._idmk_list.prepare();
        this._armk_list.prepare();
        this._psmk_list.prepare();
        this._on_sq_handler.prepare(i_sensor.getPerspectiveCopy(), i_sensor.getGsImage(), th);
        this._sqdetect.detectMarkerCb(i_sensor, th, this._on_sq_handler);
        this._tracking_list.finish();
        this._armk_list.finish();
        this._idmk_list.finish();
        this._psmk_list.finish();
        int i = this._tracking_list.size() - 1;
        while (i >= 0) {
            TMarkerData item = (TMarkerData)this._tracking_list.get(i);
            if (item.lost_count > this.lost_th) {
                item.life = 0L;
            } else if (item.sq != null && !this._transmat.transMatContinue(item.sq, item.marker_offset, item.tmat, item.last_param.last_error, item.tmat, item.last_param) && !this._transmat.transMat(item.sq, item.marker_offset, item.tmat, item.last_param)) {
                item.life = 0L;
            }
            --i;
        }
        i = this._armk_list.size() - 1;
        while (i >= 0) {
            target = (TMarkerData)this._armk_list.get(i);
            if (target.lost_count == 0) {
                target.time_stamp = time_stamp;
                if (target.life == 1L) {
                    this._transmat.transMat(target.sq, target.marker_offset, target.tmat, target.last_param);
                }
            }
            --i;
        }
        i = this._idmk_list.size() - 1;
        while (i >= 0) {
            target = (TMarkerData)this._idmk_list.get(i);
            if (target.lost_count == 0) {
                target.time_stamp = time_stamp;
                if (target.life == 1L) {
                    this._transmat.transMat(target.sq, target.marker_offset, target.tmat, target.last_param);
                }
            }
            --i;
        }
        i = this._psmk_list.size() - 1;
        while (i >= 0) {
            target = (TMarkerData)this._psmk_list.get(i);
            if (target.lost_count == 0) {
                target.time_stamp = time_stamp;
                if (target.life == 1L) {
                    this._transmat.transMat(target.sq, target.marker_offset, target.tmat, target.last_param);
                }
            }
            --i;
        }
        this._time_stamp = time_stamp;
        this._last_gs_th = th;
    }
}

