/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.markersystem.utils;

import java.util.ArrayList;
import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.markersystem.utils.SquareStack;
import jp.nyatla.nyartoolkit.markersystem.utils.TMarkerData;
import jp.nyatla.nyartoolkit.nyidmarker.NyIdMarkerParam;
import jp.nyatla.nyartoolkit.nyidmarker.NyIdMarkerPattern;
import jp.nyatla.nyartoolkit.nyidmarker.NyIdMarkerPickup;
import jp.nyatla.nyartoolkit.nyidmarker.data.NyIdMarkerDataEncoder_RawBitId;
import jp.nyatla.nyartoolkit.nyidmarker.data.NyIdMarkerData_RawBitId;

public class NyIdList
extends ArrayList<Item> {
    private static final long serialVersionUID = -6446466460932931830L;
    private NyIdMarkerPickup _id_pickup;
    private final NyIdMarkerPattern _id_patt = new NyIdMarkerPattern();
    private final NyIdMarkerParam _id_param = new NyIdMarkerParam();
    private final NyIdMarkerDataEncoder_RawBitId _id_encoder = new NyIdMarkerDataEncoder_RawBitId();
    private final NyIdMarkerData_RawBitId _id_data = new NyIdMarkerData_RawBitId();

    public NyIdList() throws NyARException {
        this._id_pickup = new NyIdMarkerPickup();
    }

    public void prepare() {
    }

    public boolean update(INyARGrayscaleRaster i_raster, SquareStack.Item i_sq) throws NyARException {
        if (!this._id_pickup.pickFromRaster(i_raster.getGsPixelDriver(), i_sq.ob_vertex, this._id_patt, this._id_param)) {
            return false;
        }
        if (!this._id_encoder.encode(this._id_patt, this._id_data)) {
            return false;
        }
        long s = this._id_data.marker_id;
        int i = this.size() - 1;
        while (i >= 0) {
            Item target = (Item)this.get(i);
            if (target.nyid_range_s <= s && s <= target.nyid_range_e && target.lost_count != 0) {
                target.nyid = s;
                target.dir = this._id_param.direction;
                target.sq = i_sq;
                return true;
            }
            --i;
        }
        return false;
    }

    public void finish() {
        int i = this.size() - 1;
        while (i >= 0) {
            Item target = (Item)this.get(i);
            if (target.sq != null && target.lost_count > 0) {
                target.lost_count = 0;
                target.life = target.life + 1L;
                target.sq.rotateVertexL(4 - target.dir);
                NyARIntPoint2d.shiftCopy(target.sq.ob_vertex, target.tl_vertex, 4 - target.dir);
                target.tl_center.setValue(target.sq.center2d);
                target.tl_rect_area = target.sq.rect_area;
            }
            --i;
        }
    }

    public static class Item
    extends TMarkerData {
        public final long nyid_range_s;
        public final long nyid_range_e;
        public long nyid;
        public int dir;

        public Item(long i_nyid_range_s, long i_nyid_range_e, double i_patt_size) {
            this.marker_offset.setSquare(i_patt_size);
            this.nyid_range_s = i_nyid_range_s;
            this.nyid_range_e = i_nyid_range_e;
        }
    }
}

