/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.raster.rgb;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattDeviationColorData;
import jp.nyatla.nyartoolkit.core.pixeldriver.INyARRgbPixelDriver;
import jp.nyatla.nyartoolkit.core.pixeldriver.NyARRgbPixelDriverFactory;
import jp.nyatla.nyartoolkit.core.raster.rgb.NyARRgbRaster_BasicClass;
import jp.nyatla.nyartoolkit.core.rasterdriver.INyARPerspectiveCopy;
import jp.nyatla.nyartoolkit.core.rasterdriver.NyARPerspectiveCopyFactory;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2gs.INyARRgb2GsFilter;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2gs.INyARRgb2GsFilterArtkTh;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2gs.INyARRgb2GsFilterRgbAve;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2gs.INyARRgb2GsFilterRgbCube;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2gs.INyARRgb2GsFilterYCbCr;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2gs.NyARRgb2GsFilterArtkThFactory;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2gs.NyARRgb2GsFilterFactory;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARRgbRaster
extends NyARRgbRaster_BasicClass {
    protected Object _buf;
    protected INyARRgbPixelDriver _rgb_pixel_driver;
    protected boolean _is_attached_buffer;

    public NyARRgbRaster(int i_width, int i_height, int i_raster_type, boolean i_is_alloc) throws NyARException {
        super(i_width, i_height, i_raster_type);
        this.initInstance(this._size, i_raster_type, i_is_alloc);
    }

    public NyARRgbRaster(int i_width, int i_height, int i_raster_type) throws NyARException {
        super(i_width, i_height, i_raster_type);
        this.initInstance(this._size, i_raster_type, true);
    }

    public NyARRgbRaster(int i_width, int i_height) throws NyARException {
        super(i_width, i_height, 262402);
        this.initInstance(this._size, 262402, true);
    }

    protected void initInstance(NyARIntSize i_size, int i_raster_type, boolean i_is_alloc) throws NyARException {
        switch (i_raster_type) {
            case 262402: {
                this._buf = i_is_alloc ? new int[i_size.w * i_size.h] : null;
                break;
            }
            case 65793: 
            case 65794: 
            case 65795: {
                this._buf = i_is_alloc ? new byte[i_size.w * i_size.h * 4] : null;
                break;
            }
            case 65537: 
            case 65538: {
                this._buf = i_is_alloc ? new byte[i_size.w * i_size.h * 3] : null;
                break;
            }
            case 197121: {
                this._buf = i_is_alloc ? new short[i_size.w * i_size.h] : null;
                break;
            }
            default: {
                throw new NyARException();
            }
        }
        this._rgb_pixel_driver = NyARRgbPixelDriverFactory.createDriver(this);
        this._is_attached_buffer = i_is_alloc;
    }

    @Override
    public INyARRgbPixelDriver getRgbPixelDriver() throws NyARException {
        return this._rgb_pixel_driver;
    }

    @Override
    public Object getBuffer() {
        return this._buf;
    }

    @Override
    public boolean hasBuffer() {
        return this._buf != null;
    }

    @Override
    public void wrapBuffer(Object i_ref_buf) throws NyARException {
        assert (!this._is_attached_buffer);
        this._buf = i_ref_buf;
        this._rgb_pixel_driver.switchRaster(this);
    }

    @Override
    public Object createInterface(Class<?> iIid) throws NyARException {
        if (iIid == INyARPerspectiveCopy.class) {
            return NyARPerspectiveCopyFactory.createDriver(this);
        }
        if (iIid == NyARMatchPattDeviationColorData.IRasterDriver.class) {
            return NyARMatchPattDeviationColorData.RasterDriverFactory.createDriver(this);
        }
        if (iIid == INyARRgb2GsFilter.class) {
            return NyARRgb2GsFilterFactory.createRgbAveDriver(this);
        }
        if (iIid == INyARRgb2GsFilterRgbAve.class) {
            return NyARRgb2GsFilterFactory.createRgbAveDriver(this);
        }
        if (iIid == INyARRgb2GsFilterRgbCube.class) {
            return NyARRgb2GsFilterFactory.createRgbCubeDriver(this);
        }
        if (iIid == INyARRgb2GsFilterYCbCr.class) {
            return NyARRgb2GsFilterFactory.createYCbCrDriver(this);
        }
        if (iIid == INyARRgb2GsFilterArtkTh.class) {
            return NyARRgb2GsFilterArtkThFactory.createDriver(this);
        }
        throw new NyARException();
    }
}

