/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.pixeldriver;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.pixeldriver.INyARRgbPixelDriver;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

final class NyARRgbPixelDriver_BYTE1D_B8G8R8X8_32
implements INyARRgbPixelDriver {
    private byte[] _ref_buf;
    private NyARIntSize _ref_size;

    NyARRgbPixelDriver_BYTE1D_B8G8R8X8_32() {
    }

    @Override
    public NyARIntSize getSize() {
        return this._ref_size;
    }

    @Override
    public void getPixel(int i_x, int i_y, int[] o_rgb) {
        byte[] ref_buf = this._ref_buf;
        int bp = (i_x + i_y * this._ref_size.w) * 4;
        o_rgb[0] = ref_buf[bp + 2] & 0xFF;
        o_rgb[1] = ref_buf[bp + 1] & 0xFF;
        o_rgb[2] = ref_buf[bp + 0] & 0xFF;
    }

    @Override
    public void getPixelSet(int[] i_x, int[] i_y, int i_num, int[] o_rgb) {
        int width = this._ref_size.w;
        byte[] ref_buf = this._ref_buf;
        int i = i_num - 1;
        while (i >= 0) {
            int bp = (i_x[i] + i_y[i] * width) * 4;
            o_rgb[i * 3 + 0] = ref_buf[bp + 2] & 0xFF;
            o_rgb[i * 3 + 1] = ref_buf[bp + 1] & 0xFF;
            o_rgb[i * 3 + 2] = ref_buf[bp + 0] & 0xFF;
            --i;
        }
    }

    @Override
    public void setPixel(int i_x, int i_y, int[] i_rgb) throws NyARException {
        byte[] ref_buf = this._ref_buf;
        int bp = (i_x + i_y * this._ref_size.w) * 4;
        ref_buf[bp + 2] = (byte)i_rgb[0];
        ref_buf[bp + 1] = (byte)i_rgb[1];
        ref_buf[bp + 0] = (byte)i_rgb[2];
    }

    @Override
    public void setPixel(int i_x, int i_y, int i_r, int i_g, int i_b) throws NyARException {
        byte[] ref_buf = this._ref_buf;
        int bp = (i_x + i_y * this._ref_size.w) * 4;
        ref_buf[bp + 2] = (byte)i_r;
        ref_buf[bp + 1] = (byte)i_g;
        ref_buf[bp + 0] = (byte)i_b;
    }

    @Override
    public void setPixels(int[] i_x, int[] i_y, int i_num, int[] i_intrgb) throws NyARException {
        NyARException.notImplement();
    }

    @Override
    public void switchRaster(INyARRgbRaster i_raster) throws NyARException {
        this._ref_buf = (byte[])i_raster.getBuffer();
        this._ref_size = i_raster.getSize();
    }
}

