/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "../src/DaemonDM/IPCDaemonEngineActionThread.h"
#include <vector>

#include "common/platform.h"

#ifndef DM_IPCENGINE_API

#ifdef PLATFORM_LINUX
#define DM_IPCENGINE_API
#elif defined(PLATFORM_WINDOWS)
#ifdef DM_IPCENGINE_EXPORTS
#define DM_IPCENGINE_API __declspec(dllexport)
#else
#define DM_IPCENGINE_API __declspec(dllimport)
#endif // DM_IPCENGINE_EXPORTS
#else
#define DM_IPCENGINE_API
#endif

#endif

namespace NS_DM_Client
{

class IDaemonEngine;

class DM_IPCENGINE_API IPCDaemonEngine
{
friend class IPCDaemonEngineActionThread;
public:
    IPCDaemonEngine();
    virtual ~IPCDaemonEngine();

    virtual bool Init(IDaemonEngine* daemonEngine);
    virtual bool Start();
    virtual bool Stop();

    virtual bool Release();

protected:
    IDaemonEngine* GetDaemonEngine();

private:
    IPCDaemonEngine(const IPCDaemonEngine&);
    IPCDaemonEngine& operator=(const IPCDaemonEngine&);

    IDaemonEngine* m_engine;
    IPCDaemonEngineActionThread m_actionThread;
};

/// factory method for IPCDaemonEngine instance creation
DM_IPCENGINE_API IPCDaemonEngine* CreateDaemonIPCEngine(IDaemonEngine* daemon_engine);

}
