/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "UserInteractionDefs.h"
#include "common/Buffer.h"
#include "../src/DaemonDM/MessageListenerActionThread.h"
#include <sys/types.h>

#ifndef DM_IPCENGINE_API

#ifdef PLATFORM_LINUX
#define DM_IPCENGINE_API
#elif defined(PLATFORM_WINDOWS)
#ifdef DM_IPCENGINE_EXPORTS
#define DM_IPCENGINE_API __declspec(dllexport)
#else
#define DM_IPCENGINE_API __declspec(dllimport)
#endif // DM_IPCENGINE_EXPORTS
#else
#define DM_IPCENGINE_API
#endif

#endif

namespace NS_DM_Client
{

class IMessageHandler;

class DM_IPCENGINE_API MessageListener
{
public:
    StatusCode Init(IMessageHandler* message_handler);
    bool Release();

    StatusCode WaitMessages();
    StatusCode StopWaitingMessages();

    ~MessageListener();

    IMessageHandler* GetMessageHandler();

private:
    IMessageHandler* m_message_handler;
	MessageListenerActionThread m_actionThread;
};

/// abstract method for MessageListener instance creation
DM_IPCENGINE_API MessageListener* CreateMessageListener(IMessageHandler* message_handler);

}

