#pragma once

#include "Errors.h"
#include "commontypes.h"
#include <vector>

#include "common/platform.h"


#ifndef DM_IPCENGINE_API

#ifdef PLATFORM_LINUX
#define DM_IPCENGINE_API
#elif defined(PLATFORM_WINDOWS)
#ifdef DM_IPCENGINE_EXPORTS
#define DM_IPCENGINE_API __declspec(dllexport)
#else
#define DM_IPCENGINE_API __declspec(dllimport)
#endif // DM_IPCENGINE_EXPORTS
#else
#define DM_IPCENGINE_API
#endif

#endif


namespace NS_DM_Client
{

struct ProfileInfo
{
    char* m_Name;
    char* m_Description;
    bool m_IsEnabled;
};

class IFIFOWrapper;

class DM_IPCENGINE_API ProfileManager
{
public:
    ProfileManager();
    ~ProfileManager();

    bool Init();
    bool Release();

    // get first profile
    StatusCode FetchFirstProfileInfo(ProfileInfo& profile);

    // get next profile
    StatusCode FetchNextProfileInfo(ProfileInfo& profile);

    // release ProfileInfo instance
    void ReleaseProfileInfo(ProfileInfo& profile);

    // enable/disable specific profile
    StatusCode EnableProfile(const String& Profile_name, bool enable = true);

    void release();

private:
    ProfileManager(const ProfileManager&);
    ProfileManager& operator=(const ProfileManager&);

    IFIFOWrapper* m_fifo_request;
    IFIFOWrapper* m_fifo_response;

    // profiles
    std::vector<ProfileInfo> m_profiles;
    std::vector<ProfileInfo>::size_type m_profiles_index;
};

//factory method for getting instance of ProfileManager
DM_IPCENGINE_API ProfileManager* GetProfileManager();

}
