/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "DeviceAdapter/IDeviceAdapter.h"
#include "commontypes.h"

namespace NS_DM_Client
{
	class IWiMAXDevice;
	class MOTreeManager;
	struct NetworkParameters;
	struct Contacts;
	struct RootCA;
	struct SubscriptionParameters;
	struct CAPLEntries;
	struct ChannelPlan;
	struct RAPL;
	struct OtherSubscriptions;
	struct Primary;
	struct EAP;

	class DummyDeviceAdapter: public IDeviceAdapter
	{
	public:
		DummyDeviceAdapter();
		virtual ~DummyDeviceAdapter();

		virtual bool Init(const StringMap& settings, IDaemonEngineRequest* request = 0);

		virtual bool Open();
		virtual bool Close();
		virtual void Release();

		virtual bool GetDeviceInfo(DevInfo& deviceInfo);
		virtual bool GetDeviceDetail(DevDetail& deviceDetail);
		virtual bool GetDMAccount(DMAcc& dmAccount);
		virtual bool GetWiMAX(WiMAX& wimax);
		virtual bool GetWiMAXSupp(WiMAXSupp& wimaxSupp);

		virtual bool SetDeviceInfo(const DevInfo& deviceInfo);
		virtual bool SetDeviceDetail(const DevDetail& deviceDetail);
		virtual bool SetDMAccount(const DMAcc& dmAccount);
		virtual bool SetWiMAX(const WiMAX& wimax);
		virtual bool SetWiMAXSupp(const WiMAXSupp& wimaxSupp);

		virtual EnumFirmwareStatus InitFirmwareStorage(const char* packageName = 0, const char* location = 0);
		virtual EnumFirmwareStatus ResetFirmwareStorage();
		virtual EnumFirmwareStatus AppendFirmwareChunk(const char* buffer, size_t size, bool last);
		virtual EnumFirmwareStatus UpdateFirmware();

		virtual bool SetEMSK(const void*, size_t size);
		virtual bool GetEMSK(void*, size_t& size);

		virtual bool SetDeviceID(const String& deviceID);
		virtual bool GetDeviceID(String& deviceID);

		virtual bool SetManufacturer(const String& manufacturer);
		virtual bool GetManufacturer(String& manufacturer);

		virtual bool SetModel(const String& model);
		virtual bool GetModel(String& model);

		virtual bool GetNetworkInterfaceName(char*, size_t& size);

	private:
		bool initFirmwareUpdater(const char* defFWPackageName, const char* defFWPackageLocation,
			bool noCleanStorage, bool fwUpdateFailure);
		void setFirmwareUpdater(IFirmwareUpdater* fu);

		virtual bool getEMSKfromCustomSource(void*, size_t& size);

	private:
		NS_Logging::Logger& m_logger;
		IFirmwareUpdater*	m_fwUpdater;

		String	m_EMSKSource;
		std::vector<byte> m_EMSKBuffer;
		String	m_deviceID; // e.g. MAC-address
		String	m_manufacturer;
		String	m_model;

		String	m_networkIFName; // system network interface name assosiated with the device
	};
}
