/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */ 

#pragma once

#include "commontypes.h"
#include "IMgmtObject.h"

namespace NS_DM_Client
{
	class IMOTreeManager;
	class TNDSCreator;
	class TNDSExtractor;

	struct MANAGEMENTOBJECTS_API AppAddr
	{
		String m_Addr;
		String m_AddrType;	
		String m_PortNbr;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct MANAGEMENTOBJECTS_API AppAuth
	{	
		String m_AAuthLevel;
		String m_AAuthType;
		String m_AAuthName;
		String m_AAuthSecret;
		String m_AAuthData;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	// TODO: DmAccount should be as array of DMAccs and "clearwire" instead of "0"
	class MANAGEMENTOBJECTS_API DMAccImpl
	{
	public:
		String m_AppID;
		String m_ServerID;
		String m_Name;
		String m_PrefConRef;
		std::vector<String> m_ToConRef;
		std::vector<AppAddr> m_AppAddr;
		String m_AAuthPref;
		std::vector<AppAuth> m_AppAuth;

	public:
		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	class MANAGEMENTOBJECTS_API DMAcc : public IMgmtObject
	{
	public:
		std::vector<DMAccImpl> m_DMAccImpl;

	public:
		virtual bool Serialize(IMOTreeManager& treeManager) const;
		virtual bool Deserialize(IMOTreeManager& treeManager);

		virtual bool Serialize(String& xml) const;
		virtual bool Deserialize(const String& xml);
	};
}
