/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <NotificationListener/INotificationListener.h>
#include <NotificationListener/UDPListener.h>

#include <Logger/Logger.h>

#include <commontypes.h>
#include <Starter.h>

namespace NS_DM_Client
{

    class ProfileComponentsHolder;

namespace NS_NotificationListener
{

    class ListenerThread;
    class MessageHandler;

    class NotificationListener :
        public INotificationListener
    {
    public:
        NotificationListener(void);
        virtual ~NotificationListener(void);

        virtual bool Init(const StringMap& settings, const String& loggerInstance, ProfileComponentsHolder& pch);
        virtual bool Start();
        virtual bool Stop();
        virtual void Release();


    protected:
		void    setListenerThread(ListenerThread* lthread);
        void    setMessageHandlerThread(NS_Common::Starter* thread);

        void    setListener(UDPListener* listener);
		void    setHandler(MessageHandler* handler);

    private:
        UDPListener*     m_listener;
        ProfileComponentsHolder*    m_pch;

        bool            m_checkNMDiggest;

        String          m_IP;
        unsigned        m_port;

        ListenerThread*     m_ListenerThread;

        MessageHandler*         m_msgHandler;

        NS_Common::Starter*     m_msgHandlerThread;

        NS_Logging::Logger*     m_logger;

        String			m_dumpPath;
    };

}

}
