#pragma once

#include <platform.h>
#include <climits>

//
// Notification message header (without Server Identifier)
//
#pragma pack(push,1)

struct NOTIFICATION_MESSAGE_HDR
{
#if CHAR_BIT != 8
#error "Code assume 8 bits in 'char'"
#endif

    char diggest[128 / CHAR_BIT];

#ifdef PLT_BIG_ENDIAN
    unsigned long   version             : 10;
    unsigned long   ui_mode             : 2;
    unsigned long   initiator           : 1;
    unsigned long   _future             : 19;
#else
    unsigned long   _future             : 19;
    unsigned long   initiator           : 1;
    unsigned long   ui_mode             : 2;
    unsigned long   version             : 10;
#endif

    unsigned char            _future_end;

#ifdef PLT_BIG_ENDIAN
    unsigned char            session_id_high;
    unsigned char            session_id_low;
#else
    unsigned char            session_id_low;
    unsigned char            session_id_high;
#endif

    unsigned char   server_id_len;

    //  char*       server_id;  // length is defined in run-time

};

#pragma pack(pop)


