/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

namespace NS_DM_Client
{
	enum StatusCode
	{
		e_Ok                             = 200,
		e_AcceptForProcessing            = 202,
		e_ChunkedItemAcceptedAndBuffered = 213,
		e_OperationCancelled             = 214,
		e_NotExecuted                    = 215,
		e_AtomicRollbackOK               = 216,
		e_NotModified                    = 304,
		e_Unauthorized                   = 401,
		e_NotFound                       = 404,
		e_ForbiddenCommand               = 405,
		e_OptionalFeatureNotSupported    = 406,
		e_AuthenticationRequired         = 407,
		e_IncompleteCommand              = 412,
		e_EntityTooLarge                 = 413,
		e_UnsupportedMediaTypeOrFormat   = 415,
		e_AlreadyExists                  = 418,
		e_DeviceFull                     = 420,
		e_SizeMismatch                   = 424,
		e_PermissionDenied               = 425,
		e_CommandFailed                  = 500,
		e_Failed                         = 501,
		e_AtomicFailed                   = 507,
		e_AtomicRollBackFailed           = 516,
		e_WriteInstanceNotAlive          = 600,
		e_ReadInstanceNotAlive           = 601,
		e_Stop                           = 700
	};
}

