/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <syncml/core/SyncML.h>

namespace NS_DM_Client
{
	namespace NS_Common
	{
		/// Class represents a sync object on which thread may wait
		class WBXMLUtils
		{
		public:

			/// Parse WBXML into SyncML message of Funambol SDK
			/// @param wbxml string of wbxml message
			/// @param wbxmllength number of characters in wbxml message
			/// @param syncml pointer to SyncML, which is valid object upon return from the Parse
			/// @return status code; values are from the wbxml_errors.h (0 means successful convertion);
			///
			/// Caller is responsible to delete returned pointer to SyncML.
			/// No meaningful value is placed into the syncml pointer on error.
			static int Parse(const char *wbxml, const unsigned int wbxmllength, Funambol::SyncML **syncml);

			/// Parse WBXML into the xml
			/// @param wbxml string of wbxml message
			/// @param wbxmllength number of characters in wbxml message
			/// @param xml pointer to xml
			/// @return status code; values are from the wbxml_errors.h (0 means successful convertion);
			///
			/// Returned pointer whould be freesd with the wbxml_free() function
			static int Parse(const char *wbxml, const unsigned int wbxmllength, char **xml);

			/// Create wbxml message from passed SyncML instance
			//static int FormatToWBXML(const Funambol::SyncML *syncml, const char **wbxml);
			/// Create wbxml message from passed syncml message
			static int FormatToWBXML(const char *syncml, const char **wbxml, unsigned int *wbxmllength);

		private:
			WBXMLUtils();
			~WBXMLUtils();
		};
	}
}
