/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#if defined(_WIN32) || defined(WIN32) || defined(_WIN64)
#define PLATFORM_WINDOWS
#endif

#ifdef _MSC_VER

#ifndef PLATFORM_WINDOWS
#define PLATFORM_WINDOWS
#endif

#if defined(_M_IX86) || defined(_M_IX64) || defined(_M_X64)
#define PLT_LITTLE_ENDIAN
#endif

#endif  // _MSC_VER


#ifdef __GNUG__

#if defined(__linux__) || defined(__linux) || defined(linux)
#define PLATFORM_LINUX
#define PLATFORM_POSIX
#endif


#ifdef ANDROID
#define PLATFORM_ANDROID
#define PLATFORM_POSIX
#endif

#ifdef __i386__
#define PLT_LITTLE_ENDIAN
#endif

#ifdef __MACH__
#define PLATFORM_MAC
#define PLATFORM_POSIX
#endif

#endif


#ifdef PLATFORM_WINDOWS
#define PLATFORM_DEFINED
#endif

#ifdef PLATFORM_LINUX
#define PLATFORM_DEFINED
#endif

#ifdef PLATFORM_ANDROID
#define PLATFORM_DEFINED
#endif

#ifdef PLATFORM_MAC
#define PLATFORM_DEFINED
#endif


#if !defined(PLT_LITTLE_ENDIAN) && !defined(PLT_BIG_ENDIAN)
#define PLT_LITTLE_ENDIAN
#endif

#ifndef PLATFORM_DEFINED
#error Platform is undefined!
#endif
